/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.cache.push;

import com.bxm.warcar.cache.KeyGenerator;
import org.apache.commons.lang.ArrayUtils;

import java.util.Map;

/**
 * @see JSONObjectPushable
 * @author allen
 * @date 2017-12-05
 */
public abstract class AbstractObjectPushable<T> extends AbstractPushable<T> {

    public AbstractObjectPushable() {
        super();
    }

    public AbstractObjectPushable(Converter converter) {
        super(converter);
    }

    protected abstract T serialize(byte[] data);

    protected abstract KeyGenerator getKeyGenerator(Map<String, Object> parameters);

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        T object = ArrayUtils.isNotEmpty(data) ? serialize(data) : null;

        KeyGenerator keyGenerator = getKeyGenerator(parameters);

        doUpdate(object, keyGenerator, parameters, data);
    }
}
