package com.bxm.warcar.ip;

import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * @author allen
 * @since 1.0.0
 */
public class IpResultSet implements Serializable {

    private static final long serialVersionUID = -5478457743871613741L;

    private List<IpResult> results = Lists.newArrayList();

    public void add(IpResult ipResult) {
        results.add(ipResult);
    }

    public IP get() {
        if (CollectionUtils.isEmpty(results)) {
            return null;
        }
        for (IpResult result : results) {
            IP ip = result.getIp();
            if (null != ip) {
                return ip;
            }
        }
        return null;
    }

    public boolean isMatched() {
        if (CollectionUtils.isEmpty(results)) {
            return true;
        }
        int size = results.size();
        if (size == 1) {
            return true;
        }

        String first = null;
        for (int i = 0; i < size; i++) {
            IP ip = results.get(i).getIp();
            if (null == ip) {
                continue;
            }
            if (i == 0) {
                first = ip.getRegioncode();
                continue;
            }

            if (!StringUtils.equals(first, ip.getRegioncode())) {
                return false;
            }
        }
        return true;
    }

    public List<IpResult> getResults() {
        return results;
    }

    public void setResults(List<IpResult> results) {
        this.results = results;
    }
}
