package com.bxm.warcar.utils.http;

import java.io.IOException;
import java.util.Map;

/**
 * <h3>http 连接池请求，默认使用{@link com.bxm.warcar.utils.http.pool.HttpClientPool}</h3>
 *  <p>
 *      其他实现{@link com.bxm.warcar.utils.http.pool.RestTemplatePool}
 *      {@link com.bxm.warcar.utils.http.pool.OkHttpPool}
 *  </p>
 * @author hcmony
 * @since V1.0.0, 2020/3/18 16:59
 */
public interface HttpPool {
    /**
     * get 请求url后面拼接参数
     *
     * @param url http://api.bianxiao.com?test=1
     * @return
     */
    public String get(String url) throws IOException;

    /**
     * get 请求url后面拼接参数
     *
     * @param url     http://api.bianxiao.com?test=1
     * @param headers heders传参
     * @return
     */
    public String get(String url, Map<String, String> headers) throws IOException;

    /**
     * get 请求
     *
     * @param url     http://api.bianxiao.com
     * @param params  params传参
     * @param headers heders传参
     * @return
     */
    public String get(String url, Map<String, Object> params, Map<String, String> headers) throws IOException;

    /**
     * @param url http://api.bianxiao.com
     * @return
     */
    public String post(String url) throws IOException;

    /**
     * post 请求
     *
     * @param url    http://api.bianxiao.com
     * @param params params传参
     * @return
     */
    public String post(String url, Map<String, Object> params) throws IOException;

    /**
     * post 请求
     *
     * @param url     http://api.bianxiao.com
     * @param params  params传参
     * @param headers heders传参
     * @return
     */
    public String post(String url, Map<String, Object> params, Map<String, String> headers) throws IOException;

    /**
     * post 请求 支持@RequestBody 传参请求
     *
     * @param url     http://api.bianxiao.com
     * @param o       实体传参
     * @param headers heders传参
     * @return
     */
    public String postRequestBody(String url, Object o, Map<String, String> headers) throws IOException;
}
