/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.pair.local;

import com.bxm.warcar.integration.pair.DefaultValue;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.integration.pair.Value;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadingCachePairImpl
implements Pair {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadingCachePairImpl.class);
    private final LoadingCache<String, Optional<String>> cache;
    private final Pair source;

    public LoadingCachePairImpl(Pair souce) {
        this(souce, 5, TimeUnit.MINUTES);
    }

    public LoadingCachePairImpl(final Pair source, int duration, TimeUnit timeUnit) {
        this.cache = CacheBuilder.newBuilder().refreshAfterWrite((long)duration, timeUnit).expireAfterWrite((long)(duration * 2), timeUnit).build((CacheLoader)new CacheLoader<String, Optional<String>>(){

            public Optional<String> load(String key) throws Exception {
                Value value = source.get(key);
                return Optional.ofNullable(value.of());
            }
        });
        this.source = source;
    }

    @Override
    public Value get(String key) {
        return new DefaultValue(this.get0(key));
    }

    @Override
    public Collection<String> keys() {
        return this.source.keys();
    }

    private String get0(String key) {
        try {
            Optional optional = (Optional)this.cache.get((Object)key);
            return optional.orElse(null);
        }
        catch (ExecutionException e) {
            LOGGER.error("get: ", (Throwable)e);
            return null;
        }
    }
}

