/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.ip.impl;

import com.bxm.warcar.ip.IP;
import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.utils.LifeCycle;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class IpIpNetIpLibrary
extends LifeCycle
implements IpLibrary {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpIpNetIpLibrary.class);
    protected File ipFile;
    private int offset;
    private int[] index = new int[65536];
    private ByteBuffer dataBuffer;
    private ByteBuffer indexBuffer;
    private ReentrantLock lock = new ReentrantLock();

    public IpIpNetIpLibrary(File ipFile) {
        Preconditions.checkNotNull((Object)ipFile);
        this.ipFile = ipFile;
    }

    @Override
    public IP find(String ip) {
        Object[] array = this.findIp(ip);
        if (ArrayUtils.isEmpty((Object[])array)) {
            return null;
        }
        if (array.length > 11) {
            return new IP((String)array[0], (String)array[1], (String)array[2], (String)array[3], (String)array[4], (String)array[5], (String)array[6], (String)array[7], (String)array[8], (String)array[9], (String)array[10], (String)array[11]);
        }
        if (array.length > 2) {
            return new IP((String)array[0], (String)array[1], (String)array[2]);
        }
        return null;
    }

    @Override
    protected void doInit() {
        this.refresh();
    }

    @Override
    protected void doDestroy() {
    }

    @Override
    public void refresh() {
        long start = System.currentTimeMillis();
        this.load();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Ip library (ipip) load finished in {} ms", (Object)(System.currentTimeMillis() - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] findIp(String ip) {
        byte[] areaBytes;
        if (null == this.dataBuffer) {
            throw new NullPointerException("no init.");
        }
        String[] ips = ip.split("\\.");
        int prefix_value = Integer.valueOf(ips[0]) * 256 + Integer.valueOf(ips[1]);
        long ip2long_value = this.ip2long(ip);
        int start = this.index[prefix_value];
        int max_comp_len = this.offset - 262144 - 4;
        long index_offset = -1L;
        int index_length = -1;
        byte b = 0;
        for (start = start * 9 + 262144; start < max_comp_len; start += 9) {
            long tmpInt = this.int2long(this.indexBuffer.getInt(start));
            if (tmpInt < ip2long_value) continue;
            index_offset = this.bytesToLong(b, this.indexBuffer.get(start + 6), this.indexBuffer.get(start + 5), this.indexBuffer.get(start + 4));
            index_length = ((0xFF & this.indexBuffer.get(start + 7)) << 8) + (0xFF & this.indexBuffer.get(start + 8));
            break;
        }
        this.lock.lock();
        try {
            this.dataBuffer.position(this.offset + (int)index_offset - 262144);
            areaBytes = new byte[index_length];
            this.dataBuffer.get(areaBytes, 0, index_length);
        }
        finally {
            this.lock.unlock();
        }
        return new String(areaBytes, Charset.forName("UTF-8")).split("\t", -1);
    }

    private void load() {
        this.lock.lock();
        try {
            byte[] bytes = this.getBytesByFile(this.ipFile);
            this.dataBuffer = ByteBuffer.wrap(bytes);
            this.dataBuffer.position(0);
            this.offset = this.dataBuffer.getInt();
            byte[] indexBytes = new byte[this.offset];
            this.dataBuffer.get(indexBytes, 0, this.offset - 4);
            this.indexBuffer = ByteBuffer.wrap(indexBytes);
            this.indexBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < 256; ++i) {
                for (int j = 0; j < 256; ++j) {
                    this.index[i * 256 + j] = this.indexBuffer.getInt();
                }
            }
            this.indexBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        catch (IOException e) {
            throw new RuntimeException("load", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytesByFile(File ipFile) throws IOException {
        FileInputStream fin = null;
        long len = ipFile.length();
        byte[] bs = new byte[new Long(len).intValue()];
        try {
            int i;
            fin = new FileInputStream(ipFile);
            int readBytesLength = 0;
            while ((i = ((InputStream)fin).available()) > 0) {
                ((InputStream)fin).read(bs, readBytesLength, i);
                readBytesLength += i;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (fin != null) {
                    ((InputStream)fin).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bs;
    }

    private long bytesToLong(byte a, byte b, byte c, byte d) {
        return this.int2long((a & 0xFF) << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF);
    }

    private int str2Ip(String ip) {
        String[] ss = ip.split("\\.");
        int a = Integer.parseInt(ss[0]);
        int b = Integer.parseInt(ss[1]);
        int c = Integer.parseInt(ss[2]);
        int d = Integer.parseInt(ss[3]);
        return a << 24 | b << 16 | c << 8 | d;
    }

    private long ip2long(String ip) {
        return this.int2long(this.str2Ip(ip));
    }

    private long int2long(int i) {
        long l = (long)i & Integer.MAX_VALUE;
        if (i < 0) {
            l |= 0x80000000L;
        }
        return l;
    }

    public static void main(String[] args) {
        IpIpNetIpLibrary library = new IpIpNetIpLibrary(new File("C:\\Users\\MAIBEN~1\\AppData\\Local\\Temp\\ipipnet.data"));
        library.init();
        System.out.println(library.find("117.136.79.102"));
        System.out.println(library.find("112.17.87.139"));
        System.out.println(library.find("73.32.192.246"));
        System.out.println(library.find("220.176.34.17"));
        System.out.println(library.find("220.191.32.0"));
    }
}

