/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils;

import java.util.regex.Pattern;

public class MobileHelper {
    private static final Pattern PATTERN_IMEI = Pattern.compile("\\d{12,}");
    private static final Pattern PATTERN_IDFA = Pattern.compile("^([0-9a-zA-Z]{1,})(([/\\s-][0-9a-zA-Z]{1,}){4})$");
    private static final Pattern PATTERN_MAC = Pattern.compile("^([0-9a-fA-F]{2})(([:][0-9a-fA-F]{2}){5})$");

    public static boolean isImei(String imei) {
        if (null == imei) {
            return Boolean.FALSE;
        }
        return PATTERN_IMEI.matcher(imei).find();
    }

    public static boolean isIdfa(String idfa) {
        if (null == idfa) {
            return Boolean.FALSE;
        }
        return PATTERN_IDFA.matcher(idfa).find();
    }

    public static boolean isMac(String mac) {
        if (null == mac) {
            return Boolean.FALSE;
        }
        return PATTERN_MAC.matcher(mac).find();
    }

    public static void main(String[] args) {
        System.out.println(MobileHelper.isImei("351710058880864"));
        System.out.println(MobileHelper.isIdfa("4E21D3AB-0D67-4903-9734-C98804407274"));
        System.out.println(MobileHelper.isMac("44:2A:60:71:CC:82"));
    }
}

