package com.bxm.warcar.utils.encrypt;


import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

import java.nio.charset.StandardCharsets;

import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

/**
 * 赢价解密<br/>
 * @author kerry.jiang fgf
 * @date 2020/1/16 16:00
 */
public class BxmDecryptHelper {
    
    private static final String KEY_ALGORITHM  = "AES";
    
    /**
     * 加密<br/>
     *
     * @param content 明文内容
     * @param key 密钥 16|24|32字节
     * @return
     */
    public static String encrypt(String content, String key) throws Exception {
        if (StringUtils.isBlank(content) || StringUtils.isBlank(key)) {
            return null;
        }
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        byte[] byteContent = content.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec sKey = new SecretKeySpec(key.getBytes(), KEY_ALGORITHM);
        cipher.init(Cipher.ENCRYPT_MODE, sKey);
        // 进行 AES 加密
        byte[] result = cipher.doFinal(byteContent);
        // 将 byte 数组转为十六进制的字符串
        return Hex.encodeHexString(result);
    }
    
    /**
     * 解密<br/>
     *
     * @param encryptContent 待解密内容
     * @param key 密钥 16|24|32字节
     * @return
     */
    public static String decrypt(String encryptContent, String key) throws Exception {
        // 将十六进制的加密文本转换为 byte 数组
        byte[] content = Hex.decodeHex(encryptContent);
        if (content == null) {
            return null;
        }
        SecretKeySpec sKey = new SecretKeySpec(key.getBytes(), KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(Cipher.DECRYPT_MODE, sKey);
        byte[] result = cipher.doFinal(content);
        // 将二进制转为字符串
        return new String(result);
    }
}
