/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.validate.internal;


import com.bxm.warcar.validate.AbstractValidator;

import java.lang.reflect.Field;


public class BeanValidatorWrapper extends AbstractValidator {

	private final BeanValidator beanValidator;

	public BeanValidatorWrapper(Field field, BeanValidator beanValidator) {
		super(field);
		if (null == beanValidator)
			throw new NullPointerException("beanValidator");
		this.beanValidator = beanValidator;
	}

	@Override
	protected void doValidate(Object input) throws Exception {
		Object v = getValue(input);
		if (null == v) {
			// TODO:
			return;
		}
		beanValidator.validate(v);
	}

	@Override
	public String getConstraintDesc() {
		return beanValidator.getConstraintDesc();
	}
}
