/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.distributed;

import com.google.common.collect.Maps;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.Schedules;

public class DistributedLockBeanFactory
implements BeanPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DistributedLockBeanFactory.class);
    private final Map<Method, Object> mapping = Maps.newHashMap();

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        Map annotatedMethods = MethodIntrospector.selectMethods((Class)targetClass, (MethodIntrospector.MetadataLookup)new MethodIntrospector.MetadataLookup<Set<Scheduled>>(){

            public Set<Scheduled> inspect(Method method) {
                Set scheduledMethods = AnnotatedElementUtils.getMergedRepeatableAnnotations((AnnotatedElement)method, Scheduled.class, Schedules.class);
                return !scheduledMethods.isEmpty() ? scheduledMethods : null;
            }
        });
        if (annotatedMethods.isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace("No @Scheduled annotations found on bean class: " + bean.getClass());
            }
        } else {
            for (Map.Entry entry : annotatedMethods.entrySet()) {
                Method method = (Method)entry.getKey();
                this.mapping.put(method, bean);
            }
            if (logger.isInfoEnabled()) {
                logger.info(annotatedMethods.size() + " @Scheduled methods has been found on bean '" + beanName + "': " + annotatedMethods);
            }
        }
        return bean;
    }

    public Map<Method, Object> getMapping() {
        return this.mapping;
    }
}

