/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.message.dingding;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.bxm.warcar.AbstractMessageSender;
import com.bxm.warcar.MessageException;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import com.bxm.warcar.utils.JsonHelper;
import java.io.Serializable;
import java.util.HashMap;
import org.springframework.http.ResponseEntity;

public class DingDingMessageSender
extends AbstractMessageSender
implements MessageSender {
    private final String url;

    public DingDingMessageSender(String url) {
        this.url = url;
    }

    @Override
    public boolean send(Message message) {
        try {
            this.send2(message);
            return true;
        }
        catch (MessageException e) {
            return false;
        }
    }

    @Override
    public void send2(Message message) throws MessageException {
        JSONObject jsonParam = new JSONObject();
        HashMap<String, String> text = new HashMap<String, String>();
        text.put("content", message.getContent());
        HashMap<String, Object> at = new HashMap<String, Object>();
        at.put("atMobiles", message.getTos());
        at.put("isAtAll", false);
        jsonParam.put("msgtype", (Object)"text");
        jsonParam.put("text", text);
        jsonParam.put("at", at);
        ResponseEntity<String> responseEntity = this.postForEntity(this.url, jsonParam);
        String response = (String)responseEntity.getBody();
        if (null == response) {
            throw new MessageException("Return body has be empty!");
        }
        SendResult body = null;
        try {
            body = JsonHelper.convert(response, SendResult.class);
        }
        catch (JSONException e) {
            throw new MessageException("Json syntax error!");
        }
        if (null == body) {
            throw new MessageException("Illegal body object!");
        }
        if (!body.isSucceed()) {
            throw new MessageException(body.getErrmsg(), String.valueOf(body.getErrcode()));
        }
    }

    public static class SendResult
    implements Serializable {
        private static final long serialVersionUID = -9083143317071986607L;
        private int errcode = -1;
        private String errmsg;

        public boolean isSucceed() {
            return this.errcode == 0;
        }

        public int getErrcode() {
            return this.errcode;
        }

        public void setErrcode(int errcode) {
            this.errcode = errcode;
        }

        public String getErrmsg() {
            return this.errmsg;
        }

        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }
    }
}

