/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.crypto;

import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public final class AesCipher {
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    public static byte[] encrypt(byte[] key, byte[] content) throws Exception {
        if (Objects.isNull(key) || Objects.isNull(content)) {
            return null;
        }
        Cipher instance = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
        SecretKeySpec sKey = AesCipher.getSecretKeySpec(key);
        instance.init(1, sKey);
        return instance.doFinal(content);
    }

    public static byte[] decrypt(byte[] key, byte[] content) throws Exception {
        if (content == null) {
            return null;
        }
        Cipher instance = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
        SecretKeySpec sKey = AesCipher.getSecretKeySpec(key);
        instance.init(2, sKey);
        return instance.doFinal(content);
    }

    private static SecretKeySpec getSecretKeySpec(byte[] key) {
        return new SecretKeySpec(key, KEY_ALGORITHM);
    }
}

