/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.validate.internal;

import com.bxm.warcar.validate.AbstractValidator;
import com.bxm.warcar.validate.ConstraintViolationException;
import com.bxm.warcar.validate.ValidateException;
import org.apache.commons.lang.StringUtils;

import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class PatternValidator extends AbstractValidator {

	private final Pattern pattern;

	public PatternValidator(Field field, String regex) {
		super(field);
		if (StringUtils.isBlank(regex))
			throw new IllegalArgumentException("regex is blank.");
		pattern = Pattern.compile(regex);
	}

	public PatternValidator(Field field, String regex, String defaultValue) {
		super(field, defaultValue);
		if (StringUtils.isBlank(regex))
			throw new IllegalArgumentException("regex is blank.");
		pattern = Pattern.compile(regex);
	}

	@Override
	protected void doValidate(Object input) throws Exception {
		Object _v = getValue(input);
		String defaultValue = getDefaultValue();
		if (!(_v instanceof String)) {
			throw new ValidateException("Expect String,but " + _v);
		}
		String v = (String) _v;
		Matcher m = pattern.matcher(v);
		if (!m.matches()) {
			if (defaultValue != null) {
				setValue(input, defaultValue);
			}else {
				throw new ConstraintViolationException(this, v);
			}
		}
	}

	@Override
	public String getConstraintDesc() {
		return getFieldDesc() + " match Pattern:" + pattern;
	}
}
