package com.bxm.warcar.utils.file;

import com.google.common.base.Preconditions;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * @author allen
 * @date 2021-04-20
 * @since 1.0
 */
public class SimpleByteTracker implements ByteTracker {

    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleDataTracker.class);
    private final String url;
    private final String cacheFileName;

    public SimpleByteTracker(String url, String cacheFileName) {
        Preconditions.checkArgument(StringUtils.isNotBlank(url));
        Preconditions.checkArgument(StringUtils.isNotBlank(cacheFileName));
        this.url = url;
        this.cacheFileName = cacheFileName;
    }

    @Override
    public byte[] getContent() {
        HttpURLConnection urlConnection = null;
        InputStream inputStream = null;
        ByteArrayOutputStream os = null;
        try {
            urlConnection = (HttpURLConnection) new URL(url).openConnection();
            inputStream = urlConnection.getInputStream();
            int available = inputStream.available();
            long start = System.currentTimeMillis();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("{} Starting download, The content length is {}...", url, available);
            }

            os = new ByteArrayOutputStream(available);

            byte[] buffer = new byte[10 * 1024 * 1024];
            int len;
            while ((len = inputStream.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            os.flush();

            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("{} Finished in {} ms!", url, (System.currentTimeMillis() - start));
            }

            return os.toByteArray();
        } catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("getLicense: ", e);
            }
            return null;
        } finally {
            IOUtils.closeQuietly(inputStream);
            if (null != urlConnection) {
                urlConnection.disconnect();
            }
        }
    }

    @Override
    public String getCacheFileName() {
        return this.cacheFileName;
    }
}
