package com.bxm.warcar.utils.localdate;

import java.time.*;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * <h3>此类方法基于LocalDateTime,LocalDate,LocalTime</h3>
 * <p></p>
 *
 * @author hcmony
 * @see LocalDateTime,LocalDate,LocalTime
 * @since V1.0.0, 2019/01/17 11:58
 */
public final class LocalDateTimeHelper {

    private LocalDateTimeHelper() {
    }

    /**
     * 8位的时间格式
     */
    public static final String PATTERN_STR8 = "yyyyMMdd";
    /**
     * 10位时间格式
     */
    public static final String PATTERN_STR10 = "yyyy-MM-dd";
    /**
     * 14位时间格式
     */
    public static final String PATTERN_STR14 = "yyyyMMddHHmmss";

    /**
     * 23位时间格式
     */
    public static final String PATTERN_STR17 = "yyyyMMddHHmmssSSS";

    /**
     * 19位时间格式
     */
    public static final String PATTERN_STR19 = "yyyy-MM-dd HH:mm:ss";

    /**
     * 23位时间格式
     */
    public static final String PATTERN_STR23 = "yyyy-MM-dd HH:mm:ss.SSS";

    /**
     * yyyyMMdd
     *
     * @return
     */
    public static String getDateStringNow() {
        return formatToString(PATTERN_STR8);
    }

    /**
     * @param pattern
     * @return
     */
    public static String formatToString(String pattern) {
        return formatToString(LocalDateTime.now(), pattern);
    }

    /**
     * @param pattern
     * @return
     */
    public static String formatToString(LocalDateTime localDateTime, String pattern) {
        return localDateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    /**
     * 以yyyyMMdd 返回前一日
     *
     * @return
     */
    public static String preDateString() {
        return plusDayString(-1, LocalDateTimeHelper.PATTERN_STR8);
    }

    /**
     * 自定义格式返回前几日
     *
     * @return
     */
    public static String plusDayString(long daysToAdd, String pattern) {
        return LocalDateTimeHelper.formatToString(
                LocalDate.now().plusDays(daysToAdd).atTime(0, 0), pattern);
    }

    /**
     * localDateTime转成date
     *
     * @param localDateTime
     * @return
     */
    public static Date localDateTimeToDate(LocalDateTime localDateTime) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        return Date.from(zdt.toInstant());
    }

    /**
     * localDateTime转成date
     *
     * @param date
     * @return
     */
    public static LocalDateTime dateToLocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDateTime();
    }
}
