//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.alibaba.sec.license.domain;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.sec.license.O00000o0.I11111Ii;
import com.alibaba.sec.license.O00000o0.I11111i;
import com.alibaba.sec.license.enums.DataType;
import com.alibaba.sec.license.exception.LicenceErrorCodeEnum;
import com.alibaba.sec.license.exception.LicenseException;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

import com.bxm.warcar.utils.localdate.LocalDateTimeHelper;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CipherEntity {
    private static final Logger I111IiI = LoggerFactory.getLogger("lsnNotifier");
    private Date expireAt = LocalDateTimeHelper.localDateTimeToDate(LocalDateTime.of(2099, 1,1, 0, 0));;
    private Date delayAt = LocalDateTimeHelper.localDateTimeToDate(LocalDateTime.of(2099, 1,1, 0, 0));;
    private Date applyAt = new Date();
    private String rateLimit = "1000000";
    private DataType dataType;
    private String token;
    private String id;

    public CipherEntity() {
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final DataType getDataType() {
        return this.dataType;
    }

    public final String getRateLimit() {
        return this.rateLimit;
    }

    public final Date getExpireAt() {
        return Objects.isNull(this.expireAt) ? null : (Date)this.expireAt.clone();
    }

    public final Date getApplyAt() {
        return Objects.isNull(this.applyAt) ? null : (Date)this.applyAt.clone();
    }

    public final String getToken() {
        return this.token;
    }

    public final void setApplyAt(Date applyAt) {
        this.applyAt = Objects.isNull(applyAt) ? null : (Date)applyAt.clone();
    }

    public final void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public final void setToken(String token) {
        this.token = token;
    }

    public final Date getDelayAt() {
        return this.delayAt;
    }

    public final String I1111iII() throws LicenseException {
        if (!Objects.isNull(this.applyAt) && !Objects.isNull(this.delayAt) && !Objects.isNull(this.expireAt) && !Objects.isNull(this.rateLimit) && Arrays.asList(DataType.values()).contains(this.dataType)) {
            if (!Objects.isNull(this.id) && this.id.length() == 20) {
                Calendar todayCalendar = Calendar.getInstance();
                Calendar expireAtCalendar;
                (expireAtCalendar = Calendar.getInstance()).setTime(this.applyAt);
                if (Long.valueOf((todayCalendar.getTimeInMillis() - expireAtCalendar.getTimeInMillis()) / 1000L) < -172800L) {
                    throw new LicenseException(LicenceErrorCodeEnum.SYSTEM_TIME_ERR);
                } else {
                    (expireAtCalendar = Calendar.getInstance()).setTime(this.expireAt);
                    Calendar delayAtCalendar;
                    (delayAtCalendar = Calendar.getInstance()).setTime(this.delayAt);
                    long nowMillis = todayCalendar.getTimeInMillis();
                    long diffExpireSeconds = (expireAtCalendar.getTimeInMillis() - nowMillis) / 1000L;
                    long diffDelaySeconds = (delayAtCalendar.getTimeInMillis() - nowMillis) / 1000L;
                    if (diffExpireSeconds <= 2592000L && diffDelaySeconds >= 0L) {
                        String message = String.format("[fastip2geo] | 您的服务使用到期时间为 %s，请尽快续费并更新授权文件，以免服务暂停使用影响业务运转", this.expireAt.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().toString());
                        I111IiI.warn(message);
                    }

                    if (diffDelaySeconds < 0L) {
                        throw new LicenseException(LicenceErrorCodeEnum.LICENSE_EXPIRE);
                    } else {
                        return I11111Ii.I1111iiI();
                    }
                }
            } else {
                throw new LicenseException(LicenceErrorCodeEnum.LICENSE_INVALID);
            }
        } else {
            throw new LicenseException(LicenceErrorCodeEnum.LICENSE_INVALID);
        }
    }

    public final String I1111ii() {
        return "89f8e88ecb3ba691ca69e46dc29e9715";
    }
}
