package com.bxm.warcar.integration.message.annotation;

import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.*;

/**
 * <h3>声明方法支持消息队列传递</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/08
 */
@Documented
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Inherited
public @interface Messaging {

    /**
     * @return 主题
     * @deprecated 不推荐使用这种方式了，请使用 {@link MessagingTopicField} 来定义主题
     * @see MessagingTopicField
     */
    @AliasFor("topic")
    String value() default "";

    /**
     * @return 主题字段名
     * @deprecated 不推荐使用这种方式了，请使用 {@link MessagingTopicField} 来定义主题
     * @see MessagingTopicField
     */
    @Deprecated
    String topicFieldNameOfConfiguration() default "";

    /**
     * 过滤标签
     * @return
     */
    String tags() default "";

    /**
     * 消息标志，系统不做干预，完全由应用决定如何使用
     * @return
     */
    int flag() default 0;

    /**
     * 消息延迟级别，默认不延迟
     *
     * @see com.bxm.warcar.mq.DelayTimeLevel
     * @return
     */
    int delayTimeLevel() default 0;
}
