package com.bxm.warcar.message.email;

import com.bxm.warcar.MessageException;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import com.google.common.collect.Lists;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

import java.util.Properties;

/**
 * @author huxiao
 * @date 2024/2/22
 * @since 1.0.0
 */
public class EmailMessageSender implements MessageSender {

    private final JavaMailSender mailSender;

    public EmailMessageSender(String host, int port, String username, String password) {
        JavaMailSenderImpl mailSenderImpl = new JavaMailSenderImpl();
        mailSenderImpl.setHost(host);
        mailSenderImpl.setPort(port);
        mailSenderImpl.setUsername(username);
        mailSenderImpl.setPassword(password);
        // 添加SSL配置
        Properties props = mailSenderImpl.getJavaMailProperties();
        props.put("mail.smtp.ssl.trust", host);
        props.put("mail.smtp.ssl.enable", "true");
        props.put("mail.smtp.auth", "true");
        mailSender = mailSenderImpl;
    }

    @Override
    @Deprecated
    public boolean send(Message message) {
        SimpleMailMessage mailMessage = new SimpleMailMessage();
        mailMessage.setFrom(message.getFrom());
        mailMessage.setSubject(message.getSubject());
        mailMessage.setTo(message.getTos().toArray(new String[0]));
        mailMessage.setText(message.getContent());

        try {
            mailSender.send(mailMessage);
            return true;
        } catch (MailException e) {
            return false;
        }
    }

    @Override
    public void send2(Message message) throws MessageException {
        SimpleMailMessage mailMessage = new SimpleMailMessage();
        mailMessage.setFrom(message.getFrom());
        mailMessage.setSubject(message.getSubject());
        mailMessage.setTo(message.getTos().toArray(new String[0]));
        mailMessage.setText(message.getContent());

        try {
            mailSender.send(mailMessage);
        } catch (MailException e) {
            throw new MessageException(e, "");
        }
    }

    public static void main(String[] args) {
        String username = "aigateway@bianxianmao.com";
        String password = "T5jO4pML";
        EmailMessageSender messageSender = new EmailMessageSender("smtp.qiye.aliyun.com", 465, username, password);
        Message message = new Message(username, "Hello", Lists.newArrayList("931093120@qq.com"));
        message.setSubject("验证码");
        messageSender.send2(message);
    }
}
