package com.bxm.warcar.utils;

import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author allen
 * @date 2023-03-01
 * @since 1.0
 */
public class BeanHelper {

    public static <T> void checkList(ApplicationContext applicationContext, Class<T> clazz, List<T> builders) {
        Map<String, T> beans = applicationContext.getBeansOfType(clazz);
        Set<String> loaded = builders.stream().map(BeanHelper::getClassName).collect(Collectors.toSet());
        Optional<T> noload = beans.values().stream().filter(e -> !loaded.contains(getClassName(e))).findFirst();
        if (noload.isPresent()) {
            throw new RuntimeException("Bean [" + noload.get() + "] already registered to Spring, but no add into builder List!");
        }
    }

    private static String getClassName(Object bean) {
        return ClassUtils.getUserClass(bean).getName();
    }
}
