package com.bxm.warcar.utils.crypto;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

/**
 * cipher for AES
 *
 * @author allen
 * @date 2021-08-26
 * @since 1.0
 */
public final class AesCipher {

    private static final String KEY_ALGORITHM  = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    public static byte[] encrypt(byte[] key, byte[] content) throws Exception {
        if (Objects.isNull(key) || Objects.isNull(content)) {
            return null;
        }
        Cipher instance = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
        SecretKeySpec sKey = getSecretKeySpec(key);
        instance.init(Cipher.ENCRYPT_MODE, sKey);
        return instance.doFinal(content);
    }

    public static byte[] decrypt(byte[] key, byte[] content) throws Exception {
        if (content == null) {
            return null;
        }
        Cipher instance = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
        SecretKeySpec sKey = getSecretKeySpec(key);
        instance.init(Cipher.DECRYPT_MODE, sKey);
        return instance.doFinal(content);
    }

    private static SecretKeySpec getSecretKeySpec(byte[] key) {
        return new SecretKeySpec(key, KEY_ALGORITHM);
    }
}
