/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad;

import android.content.Context;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import com.bxm.ad.BxmAdContract;
import com.bxm.ad.BxmAdModel;
import com.bxm.ad.BxmAdView;
import com.bxm.ad.BxmLoadAdListener;
import com.bxm.ad.NativeDataCallBack;
import com.bxm.ad.api.ApiHelper;
import com.bxm.ad.api.RtCallback;
import com.bxm.ad.model.BxmCheckModel;
import com.bxm.ad.model.BxmModel;
import com.bxm.ad.model.RequestCheckModel;
import com.bxm.ad.model.ResponseData;
import com.bxm.ad.utils.AppUtils;
import com.bxm.ad.utils.BuryUtils;
import com.bxm.ad.utils.DataUtils;
import com.bxm.ad.utils.LoadNativeDataUtils;
import com.bxm.ad.utils.LogUtil;
import com.bxm.ad.utils.SdkUtils;
import com.bxm.ad.utils.ShareUtil;
import com.google.gson.Gson;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.Callback;

public class BxmAdManager
implements BxmAdContract.BxmRequest {
    private Context mContext;
    private BxmAdContract.Model model;

    public BxmAdManager(Context context) {
        ShareUtil.init(context);
        this.model = new BxmAdModel();
        this.mContext = context;
        this.checkCoupon();
    }

    private void checkCoupon() {
        if (DataUtils.getBxmCheck() == null || DataUtils.getBxmCheck().size() == 0) {
            return;
        }
        RequestCheckModel model = new RequestCheckModel();
        model.setImei(SdkUtils.getIMEI(this.mContext));
        model.getCheckCoupons().addAll(DataUtils.getBxmCheck());
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new Gson().toJson((Object)model));
        ApiHelper.api().checkCoupon(requestBody).enqueue((Callback)new RtCallback<ResponseData<List<BxmCheckModel>>>(){

            @Override
            public void onRtResponse(ResponseData<List<BxmCheckModel>> data) {
                if (data != null && data.isSuccessed() && data.getReturnValue() != null && data.getReturnValue().size() > 0) {
                    DataUtils.clearData(data.getReturnValue());
                }
            }

            @Override
            public void onRtFailure(int code, String errmsg) {
                LogUtil.i("type ==  --- code == " + code + "---onRtFailure() = " + errmsg);
            }
        });
    }

    @Override
    public void requestBxmAdMode(final String posId, final BxmLoadAdListener listener) {
        if (this.mContext == null) {
            if (listener != null) {
                listener.onError(2004, "\u9700\u8981\u521d\u59cb\u5316");
            }
            return;
        }
        if (!AppUtils.isNetworkAvailable(this.mContext)) {
            if (listener != null) {
                listener.onError(2003, "\u7f51\u7edc\u4e0d\u53ef\u7528");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)posId)) {
            if (listener != null) {
                listener.onError(2007, "\u5e7f\u544a\u4f4d\u4e0d\u53ef\u4e3a\u7a7a");
            }
            return;
        }
        if (this.model == null) {
            if (listener != null) {
                listener.onError(2004, "\u9700\u8981\u521d\u59cb\u5316BxmAdManager");
            }
            return;
        }
        this.model.requestBxmAd(SdkUtils.getIMEI(this.mContext), posId).enqueue((Callback)new RtCallback<ResponseData<List<BxmModel>>>(){

            @Override
            @RequiresApi(api=21)
            public void onRtResponse(ResponseData data) {
                if (data == null || !data.isSuccessed()) {
                    listener.onNoAd();
                    return;
                }
                try {
                    List list = (List)data.getReturnValue();
                    if (list != null && list.size() > 0) {
                        ShareUtil.putString(posId, new Gson().toJson((Object)list));
                        BxmModel model = DataUtils.getShowAd(BxmAdManager.this.mContext, list);
                        if (model != null) {
                            if (!TextUtils.isEmpty((CharSequence)model.getIcon_img())) {
                                BxmAdView adView = new BxmAdView(BxmAdManager.this.mContext, model);
                                adView.setIvImage(model.getIcon_img());
                                if (listener != null) {
                                    model.setPosId(posId);
                                    model.setReqId(SdkUtils.getUUID());
                                    BuryUtils.addBuryLogInfo(BxmAdManager.this.mContext, "5", model);
                                    adView.setLisenter(listener);
                                    listener.onBxmComplete(adView);
                                }
                            } else if (listener != null) {
                                listener.onError(2005, "\u6570\u636e\u9519\u8bef");
                            }
                        } else if (listener != null) {
                            listener.onNoAd();
                        }
                    } else if (listener != null) {
                        listener.onNoAd();
                    }
                }
                catch (Exception ex) {
                    listener.onError(2005, "\u6570\u636e\u9519\u8bef");
                }
            }

            @Override
            public void onRtFailure(int code, String errmsg) {
                if (code == -1999 || code == 2002) {
                    BxmAdManager.this.loadLocalData(posId, listener);
                } else if (listener != null) {
                    listener.onError(code, errmsg);
                }
            }
        });
    }

    private void loadLocalData(final String posId, final BxmLoadAdListener listener) {
        LoadNativeDataUtils.loadLastData(posId, new NativeDataCallBack(){

            @Override
            public void onNativeData(List<BxmModel> list) {
                BxmModel model = DataUtils.getShowAd(BxmAdManager.this.mContext, list);
                if (model != null) {
                    BxmAdView adView = new BxmAdView(BxmAdManager.this.mContext, model);
                    if (!TextUtils.isEmpty((CharSequence)model.getIcon_img())) {
                        adView.setIvImage(model.getIcon_img());
                        if (listener != null) {
                            model.setPosId(posId);
                            model.setReqId(SdkUtils.getUUID());
                            adView.setLisenter(listener);
                            listener.onBxmComplete(adView);
                        }
                    }
                } else if (listener != null) {
                    listener.onNoAd();
                }
            }

            @Override
            public void onNativeNoData() {
                listener.onNoAd();
            }
        });
    }
}

