/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad;

import android.content.Context;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bxm.ad.BxmLoadAdListener;
import com.bxm.ad.R;
import com.bxm.ad.dialog.AdViewDialog;
import com.bxm.ad.model.BxmModel;
import com.bxm.ad.utils.AnimationUtil;
import com.bxm.ad.utils.AppUtils;
import com.bxm.ad.utils.BuryUtils;

public class BxmAdView
extends FrameLayout {
    private ImageView ivAd;
    private AdViewDialog adViewDialog;
    private Context mContext;
    private String url;
    private BxmModel mBxmModel;
    private boolean visibleStatus = false;
    private BxmLoadAdListener bxmLoadAdListener;
    private boolean isEnterFirst = true;

    public BxmAdView(Context context, BxmModel model) {
        super(context);
        this.mContext = context;
        this.mBxmModel = model;
        this.adViewDialog = new AdViewDialog(this.mContext, this.mBxmModel);
        this.init();
    }

    public BxmAdView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init();
    }

    public BxmAdView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.sdk_bxm_in_view, (ViewGroup)this);
        this.ivAd = (ImageView)this.findViewById(R.id.iv_ad_image);
        this.ivAd.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (Build.VERSION.SDK_INT >= 23) {
                    if (ActivityCompat.checkSelfPermission((Context)BxmAdView.this.mContext, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                        if (BxmAdView.this.bxmLoadAdListener != null) {
                            BxmAdView.this.bxmLoadAdListener.onError(2001, "Manifest.permission.WRITE_EXTERNAL_STORAGE");
                        }
                    } else {
                        BxmAdView.this.showAdDialog();
                    }
                } else {
                    BxmAdView.this.showAdDialog();
                }
            }
        });
        ImageView ivTop = (ImageView)this.findViewById(R.id.iv_top);
        ImageView ivBot = (ImageView)this.findViewById(R.id.iv_bottom);
        ((RequestBuilder)Glide.with((Context)this.mContext).load(this.mBxmModel.getCreative_top_img()).diskCacheStrategy(DiskCacheStrategy.RESOURCE)).into(ivTop);
        ((RequestBuilder)Glide.with((Context)this.mContext).load(this.mBxmModel.getCreative_bottom_img()).diskCacheStrategy(DiskCacheStrategy.RESOURCE)).into(ivBot);
    }

    public void setIvImage(String url) {
        Glide.with((Context)this.mContext).load(url).into(this.ivAd);
        if (!url.contains(".gif")) {
            AnimationUtil.startShakeByPropertyAnim(this.findViewById(R.id.rl_content));
        }
    }

    private void showAdDialog() {
        if (this.isEnterFirst) {
            this.isEnterFirst = false;
            BuryUtils.addBuryLogInfo(this.mContext, "11102", this.mBxmModel);
        } else {
            BuryUtils.addBuryLogInfo(this.mContext, "11107", this.mBxmModel);
        }
        this.adViewDialog.show();
    }

    public void render(final View mView) {
        mView.getViewTreeObserver().addOnScrollChangedListener(new ViewTreeObserver.OnScrollChangedListener(){

            public void onScrollChanged() {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (BxmAdView.this.visibleStatus != AppUtils.isVisible(mView)) {
                            BxmAdView.this.visibleStatus = AppUtils.isVisible(mView);
                            if (BxmAdView.this.visibleStatus && BxmAdView.this.bxmLoadAdListener != null) {
                                BuryUtils.addBuryLogInfo(BxmAdView.this.mContext, "6", BxmAdView.this.mBxmModel);
                                BxmAdView.this.bxmLoadAdListener.onShowAd();
                            }
                        }
                    }
                }).start();
            }
        });
        mView.setVisibility(0);
        if (AppUtils.isVisible(mView) && this.bxmLoadAdListener != null) {
            BuryUtils.addBuryLogInfo(this.mContext, "6", this.mBxmModel);
            this.bxmLoadAdListener.onShowAd();
        }
    }

    public void setLisenter(BxmLoadAdListener lisenter) {
        this.bxmLoadAdListener = lisenter;
        if (this.adViewDialog != null) {
            this.adViewDialog.setBxmListener(lisenter);
        }
    }

    public String imageUrl() {
        return this.mBxmModel.getIcon_img();
    }
}

