/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.api;

import com.bxm.ad.api.Api;
import com.bxm.ad.api.GlobalNetworkInterceptor;
import com.bxm.ad.api.NetworkInterceptor;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.converter.scalars.ScalarsConverterFactory;

public class ApiHelper {
    private static Api api;
    private static String userAgent;
    private static OkHttpClient mOkHttpClient;

    public static Api api() {
        ApiHelper.initApi();
        return api;
    }

    public static Api videoApi() {
        ApiHelper.initVideoApi();
        return api;
    }

    public static Api api(boolean force) {
        if (force) {
            ApiHelper.initApi();
        } else {
            ApiHelper.api();
        }
        return api;
    }

    public static OkHttpClient okHttpClient() {
        if (mOkHttpClient == null) {
            ApiHelper.initOkHttp();
        }
        return mOkHttpClient;
    }

    private static void initOkHttp() {
        if (mOkHttpClient != null) {
            return;
        }
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY);
        mOkHttpClient = new OkHttpClient().newBuilder().readTimeout(10L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).connectTimeout(10L, TimeUnit.SECONDS).addInterceptor((Interceptor)new GlobalNetworkInterceptor()).addInterceptor((Interceptor)loggingInterceptor).build();
    }

    private static void initVideoApi() {
        ApiHelper.initOkHttp();
        api = null;
        api = (Api)new Retrofit.Builder().baseUrl("http://172.16.20.110:18666/").addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(mOkHttpClient).build().create(Api.class);
    }

    private static void initApi() {
        ApiHelper.initOkHttp();
        api = null;
        api = (Api)new Retrofit.Builder().baseUrl("https://ticket-api.fawulu.com/").addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(mOkHttpClient).build().create(Api.class);
    }

    public static Api exApi() {
        ApiHelper.initExpouseApi();
        return api;
    }

    private static void initExpouseApi() {
        ApiHelper.initExOkHttp();
        api = null;
        api = (Api)new Retrofit.Builder().baseUrl("https://count-api.fawulu.com/").addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(mOkHttpClient).build().create(Api.class);
    }

    private static void initExOkHttp() {
        if (mOkHttpClient != null) {
            return;
        }
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY);
        mOkHttpClient = new OkHttpClient().newBuilder().readTimeout(10L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).connectTimeout(10L, TimeUnit.SECONDS).addInterceptor((Interceptor)new NetworkInterceptor()).addInterceptor((Interceptor)loggingInterceptor).build();
    }

    public static Api setApi(String url) {
        ApiHelper.setOkHttp(url);
        return api;
    }

    private static void setOkHttp(String url) {
        ApiHelper.initOkHttp();
        api = null;
        api = (Api)new Retrofit.Builder().baseUrl(url).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(mOkHttpClient).build().create(Api.class);
    }
}

