/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.api;

import android.accounts.NetworkErrorException;
import com.google.gson.JsonParseException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class RtCallback<T>
implements Callback<T> {
    public static List<String> finishCalls = new ArrayList<String>();

    public void onResponse(Call<T> call, Response<T> response) {
        Object result = response.body();
        if (response.code() == 200) {
            this.onRtResponse(result);
        } else {
            this.handlerError(response);
        }
        finishCalls.add(String.valueOf(call.hashCode()));
    }

    public void onFailure(Call<T> call, Throwable t) {
        if (call != null && call.isCanceled()) {
            return;
        }
        if (t instanceof ConnectException || t instanceof NetworkErrorException || t instanceof SocketTimeoutException || t instanceof UnknownHostException || t instanceof SocketException) {
            this.onRtFailure(-1999, "\u7f51\u7edc\u8fde\u63a5\u5f02\u5e38");
        } else if (t instanceof JsonParseException || t instanceof JSONException || t instanceof ParseException || t instanceof ClassCastException || t instanceof IllegalStateException) {
            this.onRtFailure(2002, "\u6570\u636e\u89e3\u6790\u5931\u8d25\n" + t.getMessage());
        } else {
            this.onRtFailure(-100, "\u672a\u77e5\u9519\u8bef\n" + t.getMessage());
        }
        finishCalls.add(String.valueOf(call.hashCode()));
    }

    private void handlerError(Response<T> response) {
        try {
            String error = response.message() + "";
            this.onRtFailure(response.code(), error);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.onRtFailure(-100, e.getMessage());
        }
    }

    public abstract void onRtResponse(T var1);

    public abstract void onRtFailure(int var1, String var2);

    public void onRtCommon() {
    }
}

