/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.bxm.ad.BxmLoadAdListener;
import com.bxm.ad.MyScrollView;
import com.bxm.ad.R;
import com.bxm.ad.api.BxmCallBack;
import com.bxm.ad.model.BxmModel;
import com.bxm.ad.update_app.UpdateAppBean;
import com.bxm.ad.update_app.UpdateAppHttpUtil;
import com.bxm.ad.update_app.UpdateAppManager;
import com.bxm.ad.update_app.service.DownloadService;
import com.bxm.ad.update_app.view.NumberProgressBar;
import com.bxm.ad.utils.AppUtils;
import com.bxm.ad.utils.BuryUtils;
import com.bxm.ad.utils.DataUtils;
import java.io.File;

public class AdViewDialog
extends Dialog
implements View.OnClickListener {
    private ImageView ivAdImage;
    private ImageView ivBottomImage;
    private ImageView ivClose;
    private NumberProgressBar progressBar;
    private Context mContext;
    private String url;
    private AlertDialog dialog;
    private BxmModel model;
    private BxmLoadAdListener bxmLoadAdListener;
    private TextView tvCopy;
    private TextView tvNotify;
    private TextView tv;
    private TextView tvContent;
    private LinearLayout llWay;
    private LinearLayout llContent;
    private MyScrollView scrollView;
    private UpdateAppBean updateAppBean;
    private FrameLayout flClose;
    private ImageView ivDir;

    public AdViewDialog(Context context, BxmModel model) {
        super(context, R.style.sdk_bxm_enter_exit_animate);
        this.mContext = context;
        this.model = model;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.sdk_bxm_dialog_ad_view);
        this.initWindows();
        this.initView();
        this.initClick();
        this.initData();
    }

    private void initWindows() {
        Window window = this.getWindow();
        window.setGravity(48);
        window.setBackgroundDrawableResource(17170445);
        window.setDimAmount(0.0f);
        WindowManager.LayoutParams params = window.getAttributes();
        params.width = -1;
        params.height = -2;
        window.setAttributes(params);
        this.setCanceledOnTouchOutside(true);
    }

    private void initClick() {
        this.findViewById(R.id.bt_show_context).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.iv_ad_image).setOnClickListener((View.OnClickListener)this);
        this.ivAdImage.setOnClickListener((View.OnClickListener)this);
        this.tvCopy.setOnClickListener((View.OnClickListener)this);
        this.llWay.setOnClickListener((View.OnClickListener)this);
        this.ivBottomImage.setOnClickListener((View.OnClickListener)this);
        this.flClose.setOnClickListener((View.OnClickListener)this);
    }

    private void initView() {
        this.llContent = (LinearLayout)this.findViewById(R.id.ll_content);
        this.progressBar = (NumberProgressBar)this.findViewById(R.id.num_pro_bar);
        this.ivAdImage = (ImageView)this.findViewById(R.id.iv_ad_image);
        this.ivBottomImage = (ImageView)this.findViewById(R.id.iv_ad_button);
        this.ivClose = (ImageView)this.findViewById(R.id.iv_close);
        this.llWay = (LinearLayout)this.findViewById(R.id.ll_way);
        this.tv = (TextView)this.findViewById(R.id.tv_ad_num);
        this.tvCopy = (TextView)this.findViewById(R.id.tv_copy_num);
        this.tvContent = (TextView)this.findViewById(R.id.tv_rule);
        this.tvNotify = (TextView)this.findViewById(R.id.tv_notify);
        this.scrollView = (MyScrollView)this.findViewById(R.id.scrollView);
        this.flClose = (FrameLayout)this.findViewById(R.id.fl_sdk_app_close);
        this.ivDir = (ImageView)this.findViewById(R.id.iv_sdk_dir);
    }

    private void initData() {
        if (!TextUtils.isEmpty((CharSequence)this.model.getCreative_top_img())) {
            RequestBuilder thumbnailRequest = Glide.with((Context)this.mContext).load(this.model.getCreative_top_img());
            ((RequestBuilder)Glide.with((Context)this.mContext).load(this.model.getCreative_top_img()).diskCacheStrategy(DiskCacheStrategy.RESOURCE)).thumbnail(thumbnailRequest).addListener((RequestListener)new RequestListener<Drawable>(){

                public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                    return false;
                }

                public boolean onResourceReady(Drawable resource, Object o, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                    BuryUtils.addBuryLogInfo(AdViewDialog.this.mContext, "11103", AdViewDialog.this.model);
                    AdViewDialog.this.findViewById(R.id.view_left).setVisibility(0);
                    AdViewDialog.this.findViewById(R.id.view_right).setVisibility(0);
                    AdViewDialog.this.flClose.setVisibility(0);
                    return false;
                }
            }).into(this.ivAdImage);
        }
        if (!TextUtils.isEmpty((CharSequence)this.model.getCreative_bottom_img())) {
            Glide.with((Context)this.mContext).load(this.model.getCreative_bottom_img()).into(this.ivBottomImage);
        }
        if (this.model != null && !TextUtils.isEmpty((CharSequence)this.model.getCoupons_code())) {
            this.tv.setText((CharSequence)this.model.getCoupons_code());
            this.tvCopy.setVisibility(0);
        } else {
            this.tvCopy.setVisibility(8);
        }
        if (this.model != null && !TextUtils.isEmpty((CharSequence)this.model.getCoupons_content())) {
            this.tvContent.setText((CharSequence)this.model.getCoupons_content());
        }
        if (this.model != null && !TextUtils.isEmpty((CharSequence)this.model.getCoupons_intro())) {
            this.tvNotify.setText((CharSequence)this.model.getCoupons_intro());
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.fl_sdk_app_close) {
            this.dismiss();
        } else if (v.getId() == R.id.tv_copy_num) {
            if (this.model != null && !TextUtils.isEmpty((CharSequence)this.model.getCoupons_code())) {
                AppUtils.copyTextToSystem(this.mContext, this.model.getCoupons_code());
                Toast.makeText((Context)this.mContext, (CharSequence)"\u590d\u5236\u6210\u529f", (int)0).show();
            }
        } else if (v.getId() == R.id.ll_way) {
            if (this.tvNotify.getVisibility() == 0) {
                this.tvNotify.setVisibility(8);
                this.ivDir.setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.icon_down));
            } else {
                this.tvNotify.setVisibility(0);
                this.ivDir.setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.icon_up));
            }
        } else if (v.getId() == R.id.iv_ad_image || v.getId() == R.id.iv_ad_button) {
            if (Build.VERSION.SDK_INT >= 23) {
                if (ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                    this.bxmLoadAdListener.onError(2001, "android.permission.WRITE_EXTERNAL_STORAGE");
                } else {
                    this.dealData();
                }
            } else {
                this.dealData();
            }
        }
    }

    private void dealData() {
        this.ivAdImage.setEnabled(false);
        this.ivBottomImage.setEnabled(false);
        BuryUtils.getOrderId(this.mContext, "7", this.model, new BxmCallBack(){

            @Override
            public void onComplete(String orderId) {
                AdViewDialog.this.startDownLoad();
                Intent mIntent = new Intent("order_id");
                mIntent.putExtra("order_id", orderId);
                AdViewDialog.this.mContext.sendBroadcast(mIntent);
                AdViewDialog.this.model.setCountId(orderId);
                AdViewDialog.this.ivAdImage.setEnabled(true);
                AdViewDialog.this.ivBottomImage.setEnabled(true);
                AdViewDialog.this.findViewById(R.id.rl_bt).setVisibility(8);
                if (AdViewDialog.this.findViewById(R.id.iv_ad_context).getVisibility() != 0) {
                    AdViewDialog.this.findViewById(R.id.iv_ad_context).setVisibility(0);
                    AdViewDialog.this.findViewById(R.id.iv_ad_context).setAnimation(AnimationUtils.loadAnimation((Context)AdViewDialog.this.mContext, (int)R.anim.view_in_from_top));
                }
                if (AdViewDialog.this.bxmLoadAdListener != null) {
                    AdViewDialog.this.bxmLoadAdListener.onShowAdNum();
                    if (AdViewDialog.this.model != null && AdViewDialog.this.model.getBury_point_urls() != null && AdViewDialog.this.model.getBury_point_urls().size() > 0) {
                        for (final String url : AdViewDialog.this.model.getBury_point_urls()) {
                            if (TextUtils.isEmpty((CharSequence)url)) continue;
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    BuryUtils.activeUrl(DataUtils.getStringUrl(url, AdViewDialog.this.mContext, AdViewDialog.this.model.getReqId(), AdViewDialog.this.model.getPosId(), AdViewDialog.this.model.getId(), AdViewDialog.this.model.getIcon_id(), AdViewDialog.this.model.getIcon_img()));
                                }
                            }).start();
                        }
                    }
                }
            }

            @Override
            public void onFail() {
                Toast.makeText((Context)AdViewDialog.this.mContext, (CharSequence)"\u9886\u53d6\u5931\u8d25", (int)0).show();
                AdViewDialog.this.ivAdImage.setEnabled(true);
                AdViewDialog.this.ivBottomImage.setEnabled(true);
            }
        });
    }

    private void startDownLoad() {
        if (this.model != null) {
            this.url = this.model.getUrl();
            this.onlyDownload(this.url);
        }
    }

    public void setBxmListener(BxmLoadAdListener litener) {
        this.bxmLoadAdListener = litener;
    }

    public void onlyDownload(String mApkFileUrl) {
        if (TextUtils.isEmpty((CharSequence)mApkFileUrl) || !mApkFileUrl.contains(".apk") || !mApkFileUrl.startsWith("http") && !mApkFileUrl.startsWith("https")) {
            return;
        }
        if (this.updateAppBean == null) {
            this.updateAppBean = new UpdateAppBean();
        }
        if (!TextUtils.isEmpty((CharSequence)this.updateAppBean.getApkFileUrl()) && mApkFileUrl.equals(this.updateAppBean.getApkFileUrl())) {
            return;
        }
        this.updateAppBean.setApkFileUrl(mApkFileUrl);
        String path = "";
        if (Environment.getExternalStorageState().equals("mounted") || !Environment.isExternalStorageRemovable()) {
            try {
                path = this.mContext.getExternalCacheDir().getAbsolutePath();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (TextUtils.isEmpty((CharSequence)path)) {
                path = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getAbsolutePath();
            }
        } else {
            path = this.mContext.getCacheDir().getAbsolutePath();
        }
        this.updateAppBean.setTargetPath(path);
        this.updateAppBean.setHttpManager(new UpdateAppHttpUtil());
        UpdateAppManager.download(this.mContext, this.updateAppBean, new DownloadService.DownloadCallback(){

            @Override
            public void onStart() {
                BuryUtils.addBuryLogInfo(AdViewDialog.this.mContext, "11201", AdViewDialog.this.model);
            }

            @Override
            public void onProgress(float progress, long totalSize) {
                AdViewDialog.this.progressBar.setProgress(Math.round(progress * 100.0f));
                AdViewDialog.this.progressBar.setMax(100);
            }

            @Override
            public void setMax(long totalSize) {
            }

            @Override
            public boolean onFinish(File file) {
                if (AdViewDialog.this.updateAppBean != null) {
                    AdViewDialog.this.updateAppBean.setApkFileUrl("");
                }
                return true;
            }

            @Override
            public void onError(String msg) {
                AdViewDialog.this.updateAppBean.setApkFileUrl("");
            }

            @Override
            public boolean onInstallAppAndAppOnForeground(File file) {
                return false;
            }
        });
    }

    public void show() {
        super.show();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (AdViewDialog.this.findViewById(R.id.iv_ad_context).getVisibility() == 0 && AdViewDialog.this.bxmLoadAdListener != null) {
                    AdViewDialog.this.bxmLoadAdListener.onShowAdNum();
                }
            }
        }, 2000L);
        if (this.model != null) {
            DataUtils.joinNativieExposure(this.model);
        }
        if (this.tvNotify.getVisibility() == 0) {
            this.ivDir.setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.icon_up));
        } else {
            this.ivDir.setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.icon_down));
        }
    }

    public void dismiss() {
        if (this.findViewById(R.id.iv_ad_context).getVisibility() == 0 && this.bxmLoadAdListener != null) {
            BuryUtils.addBuryLogInfo(this.mContext, "11106", this.model);
        } else {
            BuryUtils.addBuryLogInfo(this.mContext, "11104", this.model);
        }
        super.dismiss();
    }
}

