/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.dialog;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.bxm.ad.BxmSdkListener;
import com.bxm.ad.R;
import com.bxm.ad.dialog.BxmDetailDialog;
import com.bxm.ad.dialog.MyWebViewClient;
import com.bxm.ad.dialog.VideoCallBack;
import com.bxm.ad.update_app.UpdateAppBean;
import com.bxm.ad.update_app.UpdateAppHttpUtil;
import com.bxm.ad.update_app.UpdateAppManager;
import com.bxm.ad.update_app.service.DownloadService;
import java.io.File;
import org.json.JSONObject;

public class BxmWebViewDialog
extends Dialog
implements MyWebViewClient.CustomInteraction {
    private MyWebViewClient myWebViewClient;
    private WebView webView;
    private Context mContext;
    private UpdateAppBean updateAppBean;
    private VideoCallBack callBack;
    private boolean isFirst = true;
    private BxmDetailDialog detailDialog;
    private boolean inPlaying = false;
    private boolean loadSuccess = false;
    private BxmSdkListener bxmSdkListener;

    public BxmWebViewDialog(Context context, BxmSdkListener listener) {
        super(context);
        this.mContext = context;
        this.bxmSdkListener = listener;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.sdk_bxm_dialog_webview);
        this.setFitSystemWindow(false);
        this.initWindow();
        this.initView();
        this.initData();
    }

    private void initWindow() {
        Window window = this.getWindow();
        window.setBackgroundDrawableResource(17170445);
        window.setDimAmount(0.0f);
        WindowManager.LayoutParams params = window.getAttributes();
        params.width = 1;
        params.height = 1;
        window.setAttributes(params);
        this.setCanceledOnTouchOutside(true);
    }

    private void initView() {
        this.webView = (WebView)this.findViewById(R.id.web_view);
        this.getWindow().setFormat(-3);
        WebSettings setting = this.webView.getSettings();
        setting.setSupportZoom(false);
        setting.setUseWideViewPort(false);
        setting.setLoadWithOverviewMode(true);
        setting.setJavaScriptEnabled(true);
        setting.setSavePassword(false);
        setting.setBlockNetworkImage(false);
        setting.setDomStorageEnabled(true);
        setting.setDefaultTextEncodingName("utf-8");
        setting.setCacheMode(2);
        if (Build.VERSION.SDK_INT >= 21) {
            setting.setMixedContentMode(0);
        }
        this.webView.getSettings().setTextZoom(100);
        this.webView.setBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)17170445));
        this.myWebViewClient = new MyWebViewClient(this.mContext);
        this.myWebViewClient.setInteraction(this);
        this.webView.setWebViewClient((WebViewClient)this.myWebViewClient);
        this.webView.loadUrl("https://dev-test-space.oss-cn-hangzhou.aliyuncs.com/dist01/IATest/video/index.html?horizontal=" + this.getDis());
    }

    private boolean getDis() {
        Configuration cf = this.mContext.getResources().getConfiguration();
        int ori = cf.orientation;
        return ori == 2;
    }

    private void initData() {
    }

    public void show() {
        if (!this.isFirst) {
            Window window = this.getWindow();
            WindowManager.LayoutParams params = window.getAttributes();
            params.width = -1;
            params.height = -1;
            window.setAttributes(params);
            this.webView.setVisibility(0);
        }
        super.show();
        this.startPlat();
    }

    public void dismiss() {
        if (this.isFirst) {
            this.isFirst = false;
            super.dismiss();
            return;
        }
        if (this.inPlaying) {
            this.systemBack();
            return;
        }
        super.dismiss();
    }

    private void systemBack() {
        this.webView.loadUrl("javascript:systemBack()");
    }

    private void startPlat() {
        this.inPlaying = true;
        this.webView.loadUrl("javascript:startPlay()");
    }

    private void continuePlay() {
        this.inPlaying = true;
        this.webView.loadUrl("javascript:continuePlay()");
    }

    @Override
    public boolean interaction(WebView view, String url) {
        if (url.contains("bxmvd://loadVideo")) {
            this.bxmSdkListener.onBxmSuccess(null);
            this.isFirst = true;
            this.dismiss();
            return true;
        }
        if (url.contains("bxmvd://openUrl")) {
            Uri uri = Uri.parse((String)url);
            String linkUrl = uri.getQueryParameter("url");
            this.detailDialog = new BxmDetailDialog(this.mContext, linkUrl);
            this.detailDialog.setClick(new BxmDetailDialog.CallBack(){

                @Override
                public void onDismiss() {
                    BxmWebViewDialog.this.continuePlay();
                }
            });
            this.inPlaying = false;
            this.detailDialog.show();
            return true;
        }
        if (url.contains("bxmvd://downApp")) {
            Uri uri = Uri.parse((String)url);
            String linkUrl = uri.getQueryParameter("url");
            this.onlyDownload(linkUrl);
            return true;
        }
        if (url.contains("bxmvd://close")) {
            Uri u = Uri.parse((String)url);
            boolean isfinish = u.getBooleanQueryParameter("isFinish", false);
            if (isfinish) {
                this.bxmSdkListener.onVideoComplete();
            }
            super.dismiss();
            this.inPlaying = false;
            return true;
        }
        if (url.contains("bxmvd://error")) {
            Uri uri = Uri.parse((String)url);
            String json = uri.getQueryParameter("result");
            try {
                JSONObject o = new JSONObject(json);
                int code = o.getInt("code");
                String msg = o.getString("message");
                if (code == 1) {
                    this.bxmSdkListener.onBxmNoAd();
                } else {
                    this.bxmSdkListener.onBxmFailure(code, msg);
                }
            }
            catch (Exception ex) {
                this.bxmSdkListener.onBxmNoAd();
            }
            return true;
        }
        return false;
    }

    public void onlyDownload(String mApkFileUrl) {
        if (TextUtils.isEmpty((CharSequence)mApkFileUrl) || !mApkFileUrl.contains(".apk") || !mApkFileUrl.startsWith("http") && !mApkFileUrl.startsWith("https")) {
            return;
        }
        if (this.updateAppBean == null) {
            this.updateAppBean = new UpdateAppBean();
        }
        if (!TextUtils.isEmpty((CharSequence)this.updateAppBean.getApkFileUrl()) && mApkFileUrl.equals(this.updateAppBean.getApkFileUrl())) {
            return;
        }
        this.updateAppBean.setApkFileUrl(mApkFileUrl);
        String path = "";
        if (Environment.getExternalStorageState().equals("mounted") || !Environment.isExternalStorageRemovable()) {
            try {
                path = this.mContext.getExternalCacheDir().getAbsolutePath();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (TextUtils.isEmpty((CharSequence)path)) {
                path = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getAbsolutePath();
            }
        } else {
            path = this.mContext.getCacheDir().getAbsolutePath();
        }
        this.updateAppBean.setTargetPath(path);
        this.updateAppBean.setHttpManager(new UpdateAppHttpUtil());
        UpdateAppManager.download(this.mContext, this.updateAppBean, new DownloadService.DownloadCallback(){

            @Override
            public void onStart() {
            }

            @Override
            public void onProgress(float progress, long totalSize) {
            }

            @Override
            public void setMax(long totalSize) {
            }

            @Override
            public boolean onFinish(File file) {
                if (BxmWebViewDialog.this.updateAppBean != null) {
                    BxmWebViewDialog.this.updateAppBean.setApkFileUrl("");
                }
                return true;
            }

            @Override
            public void onError(String msg) {
                BxmWebViewDialog.this.updateAppBean.setApkFileUrl("");
            }

            @Override
            public boolean onInstallAppAndAppOnForeground(File file) {
                return false;
            }
        });
    }

    protected void setStatusBarFullTransparent() {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.clearFlags(0x4000000);
            window.getDecorView().setSystemUiVisibility(1280);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0);
        } else if (Build.VERSION.SDK_INT >= 19) {
            this.getWindow().addFlags(0x4000000);
        }
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    protected void setFitSystemWindow(boolean fitSystemWindow) {
        ViewGroup rootView;
        ViewGroup winContent;
        if (Build.VERSION.SDK_INT >= 19 && (winContent = (ViewGroup)this.findViewById(0x1020002)).getChildCount() > 0 && (rootView = (ViewGroup)winContent.getChildAt(0)) != null) {
            rootView.setFitsSystemWindows(fitSystemWindow);
        }
    }
}

