/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.dialog;

import android.app.Dialog;
import android.content.Context;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.view.Window;
import android.view.WindowManager;
import android.widget.MediaController;
import android.widget.VideoView;
import com.bxm.ad.R;
import com.bxm.ad.dialog.VideoCallBack;

public class VideoDialog
extends Dialog {
    private VideoView videoView;
    private Context mContext;
    private VideoCallBack callBack;

    public VideoDialog(Context context) {
        super(context, R.style.sdk_bxm_enter_exit_animate);
        this.mContext = context;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.sdk_bxm_dialog_video);
        this.initWindow();
        this.initView();
        this.initData();
    }

    private void initWindow() {
        Window window = this.getWindow();
        window.setGravity(48);
        window.setBackgroundDrawableResource(17170445);
        window.setDimAmount(0.0f);
        WindowManager.LayoutParams params = window.getAttributes();
        params.width = -1;
        params.height = -2;
        window.setAttributes(params);
        this.setCanceledOnTouchOutside(true);
    }

    private void initView() {
        this.videoView = (VideoView)this.findViewById(R.id.video_view);
    }

    private void initData() {
        String videoUrl = "http://chuangfen.oss-cn-hangzhou.aliyuncs.com/public/attachment/201803/100651/201803141624378522.mp4";
        MediaController localMediaController = new MediaController(this.mContext);
        localMediaController.setMediaPlayer((MediaController.MediaPlayerControl)this.videoView);
        localMediaController.setVisibility(8);
        this.videoView.setVideoPath(videoUrl);
        this.videoView.requestFocus();
        this.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                mp.setOnInfoListener(new MediaPlayer.OnInfoListener(){

                    public boolean onInfo(MediaPlayer mp, int what, int extra) {
                        if (what == 3) {
                            VideoDialog.this.videoView.setBackgroundColor(0);
                            return true;
                        }
                        return false;
                    }
                });
            }
        });
        this.videoView.start();
        this.callBack.onVideoStart();
    }

    public void show() {
        super.show();
        if (this.videoView != null) {
            this.videoView.start();
            this.callBack.onVideoStart();
        }
    }

    public void dismiss() {
        super.dismiss();
        if (this.callBack != null) {
            this.callBack.onVideoPause();
        }
    }
}

