/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.okhttp;

import com.bxm.ad.okhttp.builder.GetBuilder;
import com.bxm.ad.okhttp.builder.HeadBuilder;
import com.bxm.ad.okhttp.builder.OtherRequestBuilder;
import com.bxm.ad.okhttp.builder.PostFileBuilder;
import com.bxm.ad.okhttp.builder.PostFormBuilder;
import com.bxm.ad.okhttp.builder.PostStringBuilder;
import com.bxm.ad.okhttp.callback.Callback;
import com.bxm.ad.okhttp.request.RequestCall;
import com.bxm.ad.okhttp.utils.Platform;
import java.io.IOException;
import java.util.concurrent.Executor;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Response;

public class OkHttpUtils {
    public static final long DEFAULT_MILLISECONDS = 10000L;
    private static volatile OkHttpUtils mInstance;
    private OkHttpClient mOkHttpClient;
    private Platform mPlatform;

    public OkHttpUtils(OkHttpClient okHttpClient) {
        this.mOkHttpClient = okHttpClient == null ? new OkHttpClient() : okHttpClient;
        this.mPlatform = Platform.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpUtils initClient(OkHttpClient okHttpClient) {
        if (mInstance != null) return mInstance;
        Class<OkHttpUtils> clazz = OkHttpUtils.class;
        synchronized (OkHttpUtils.class) {
            if (mInstance != null) return mInstance;
            mInstance = new OkHttpUtils(okHttpClient);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    public static OkHttpUtils getInstance() {
        return OkHttpUtils.initClient(null);
    }

    public Executor getDelivery() {
        return this.mPlatform.defaultCallbackExecutor();
    }

    public OkHttpClient getOkHttpClient() {
        return this.mOkHttpClient;
    }

    public static GetBuilder get() {
        return new GetBuilder();
    }

    public static PostStringBuilder postString() {
        return new PostStringBuilder();
    }

    public static PostFileBuilder postFile() {
        return new PostFileBuilder();
    }

    public static PostFormBuilder post() {
        return new PostFormBuilder();
    }

    public static OtherRequestBuilder put() {
        return new OtherRequestBuilder("PUT");
    }

    public static HeadBuilder head() {
        return new HeadBuilder();
    }

    public static OtherRequestBuilder delete() {
        return new OtherRequestBuilder("DELETE");
    }

    public static OtherRequestBuilder patch() {
        return new OtherRequestBuilder("PATCH");
    }

    public void execute(RequestCall requestCall, Callback callback) {
        if (callback == null) {
            callback = Callback.CALLBACK_DEFAULT;
        }
        final Callback finalCallback = callback;
        final int id2 = requestCall.getOkHttpRequest().getId();
        requestCall.getCall().enqueue(new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                OkHttpUtils.this.sendFailResultCallback(call, e, finalCallback, id2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) {
                try {
                    if (call.isCanceled()) {
                        OkHttpUtils.this.sendFailResultCallback(call, new IOException("Canceled!"), finalCallback, id2);
                        return;
                    }
                    if (!finalCallback.validateReponse(response, id2)) {
                        OkHttpUtils.this.sendFailResultCallback(call, new IOException("request failed , reponse's code is : " + response.code()), finalCallback, id2);
                        return;
                    }
                    Object o = finalCallback.parseNetworkResponse(response, id2);
                    OkHttpUtils.this.sendSuccessResultCallback(o, finalCallback, id2);
                }
                catch (Exception e) {
                    OkHttpUtils.this.sendFailResultCallback(call, e, finalCallback, id2);
                }
                finally {
                    if (response.body() != null) {
                        response.body().close();
                    }
                }
            }
        });
    }

    public void sendFailResultCallback(final Call call, final Exception e, final Callback callback, final int id2) {
        if (callback == null) {
            return;
        }
        this.mPlatform.execute(new Runnable(){

            @Override
            public void run() {
                callback.onError(call, e, id2);
                callback.onAfter(id2);
            }
        });
    }

    public void sendSuccessResultCallback(final Object object, final Callback callback, final int id2) {
        if (callback == null) {
            return;
        }
        this.mPlatform.execute(new Runnable(){

            @Override
            public void run() {
                callback.onResponse(object, id2);
                callback.onAfter(id2);
            }
        });
    }

    public void cancelTag(Object tag) {
        for (Call call : this.mOkHttpClient.dispatcher().queuedCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
        for (Call call : this.mOkHttpClient.dispatcher().runningCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
    }

    public static class METHOD {
        public static final String HEAD = "HEAD";
        public static final String DELETE = "DELETE";
        public static final String PUT = "PUT";
        public static final String PATCH = "PATCH";
    }
}

