/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.okhttp.callback;

import com.bxm.ad.okhttp.OkHttpUtils;
import com.bxm.ad.okhttp.callback.Callback;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import okhttp3.Response;

public abstract class FileCallBack
extends Callback<File> {
    private String destFileDir;
    private String destFileName;

    public FileCallBack(String destFileDir, String destFileName) {
        this.destFileDir = destFileDir;
        this.destFileName = destFileName;
    }

    @Override
    public File parseNetworkResponse(Response response, int id2) throws Exception {
        return this.saveFile(response, id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveFile(Response response, final int id2) throws IOException {
        InputStream is = null;
        byte[] buf = new byte[2048];
        int len = 0;
        FileOutputStream fos = null;
        try {
            is = response.body().byteStream();
            final long total = response.body().contentLength();
            long sum = 0L;
            File dir = new File(this.destFileDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(dir, this.destFileName);
            fos = new FileOutputStream(file);
            while ((len = is.read(buf)) != -1) {
                fos.write(buf, 0, len);
                final long finalSum = sum += (long)len;
                OkHttpUtils.getInstance().getDelivery().execute(new Runnable(){

                    @Override
                    public void run() {
                        FileCallBack.this.inProgress((float)finalSum * 1.0f / (float)total, total, id2);
                    }
                });
            }
            fos.flush();
            File file2 = file;
            return file2;
        }
        finally {
            try {
                response.body().close();
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static double div(double value1, double value2, int scale) throws IllegalAccessException {
        if (scale < 0) {
            throw new IllegalAccessException("\u7cbe\u786e\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        BigDecimal b1 = new BigDecimal(value1);
        BigDecimal b2 = new BigDecimal(value2);
        return FileCallBack.fixedNumber(b1.divide(b2, scale).doubleValue());
    }

    public static double fixedNumber(double f) {
        BigDecimal bg = new BigDecimal(f);
        double f1 = bg.setScale(2, 4).doubleValue();
        return f1;
    }
}

