/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.okhttp.request;

import com.bxm.ad.okhttp.OkHttpUtils;
import com.bxm.ad.okhttp.callback.Callback;
import com.bxm.ad.okhttp.request.CountingRequestBody;
import com.bxm.ad.okhttp.request.OkHttpRequest;
import com.bxm.ad.okhttp.utils.Exceptions;
import java.io.File;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class PostFileRequest
extends OkHttpRequest {
    private static MediaType MEDIA_TYPE_STREAM = MediaType.parse((String)"application/octet-stream");
    private File file;
    private MediaType mediaType;

    public PostFileRequest(String url, Object tag, Map<String, String> params, Map<String, String> headers, File file, MediaType mediaType, int id2) {
        super(url, tag, params, headers, id2);
        this.file = file;
        this.mediaType = mediaType;
        if (this.file == null) {
            Exceptions.illegalArgument("the file can not be null !", new Object[0]);
        }
        if (this.mediaType == null) {
            this.mediaType = MEDIA_TYPE_STREAM;
        }
    }

    @Override
    protected RequestBody buildRequestBody() {
        return RequestBody.create((MediaType)this.mediaType, (File)this.file);
    }

    @Override
    protected RequestBody wrapRequestBody(RequestBody requestBody, final Callback callback) {
        if (callback == null) {
            return requestBody;
        }
        CountingRequestBody countingRequestBody = new CountingRequestBody(requestBody, new CountingRequestBody.Listener(){

            @Override
            public void onRequestProgress(final long bytesWritten, final long contentLength) {
                OkHttpUtils.getInstance().getDelivery().execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.inProgress((float)bytesWritten * 1.0f / (float)contentLength, contentLength, PostFileRequest.this.id);
                    }
                });
            }
        });
        return countingRequestBody;
    }

    @Override
    protected Request buildRequest(RequestBody requestBody) {
        return this.builder.post(requestBody).build();
    }
}

