/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.okhttp.request;

import com.bxm.ad.okhttp.request.OkHttpRequest;
import com.bxm.ad.okhttp.utils.Exceptions;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class PostStringRequest
extends OkHttpRequest {
    private static MediaType MEDIA_TYPE_PLAIN = MediaType.parse((String)"text/plain;charset=utf-8");
    private String content;
    private MediaType mediaType;

    public PostStringRequest(String url, Object tag, Map<String, String> params, Map<String, String> headers, String content, MediaType mediaType, int id2) {
        super(url, tag, params, headers, id2);
        this.content = content;
        this.mediaType = mediaType;
        if (this.content == null) {
            Exceptions.illegalArgument("the content can not be null !", new Object[0]);
        }
        if (this.mediaType == null) {
            this.mediaType = MEDIA_TYPE_PLAIN;
        }
    }

    @Override
    protected RequestBody buildRequestBody() {
        return RequestBody.create((MediaType)this.mediaType, (String)this.content);
    }

    @Override
    protected Request buildRequest(RequestBody requestBody) {
        return this.builder.post(requestBody).build();
    }
}

