/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.sdk;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.bxm.ad.BxmSdkListener;
import com.bxm.ad.dialog.BxmWebViewDialog;
import com.bxm.ad.sdk.BxmAdNative;
import com.bxm.ad.sdk.BxmManager;
import com.bxm.ad.sdk.BxmRequest;
import com.bxm.ad.sdk.BxmVideoModel;
import com.bxm.ad.ttad.TTAdUtils;
import com.bytedance.sdk.openadsdk.TTRewardVideoAd;

public class BxmLoadAd
implements BxmAdNative {
    private Activity mActivity;
    private BxmWebViewDialog dialog;
    private boolean canShow = false;
    private TTAdUtils ttAdUtils;
    private BxmVideoModel model;

    public BxmLoadAd(Activity mContext) {
        this.mActivity = mContext;
        this.ttAdUtils = new TTAdUtils(this.mActivity);
        this.model = new BxmVideoModel();
    }

    @Override
    public void loadVideoAd(BxmRequest request, BxmAdNative.BxmVideoAdListener listener) {
        if (!BxmManager.getStance().isIsInit()) {
            listener.onRequestFailure(2005, "SDK\u672a\u521d\u59cb\u5316");
            return;
        }
        if (request == null) {
            listener.onRequestFailure(2005, "\u5165\u53c2\u4e0d\u5408\u6cd5");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)request.getAppKey())) {
            listener.onRequestFailure(2005, "\u5165\u53c2\u4e0d\u5408\u6cd5");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)request.getPosId())) {
            listener.onRequestFailure(2005, "\u5165\u53c2\u4e0d\u5408\u6cd5");
            return;
        }
        this.loadTtAd(listener);
        this.loadBxmVideo(listener);
    }

    private void loadBxmVideo(final BxmAdNative.BxmVideoAdListener listener) {
        this.dialog = new BxmWebViewDialog((Context)this.mActivity, new BxmSdkListener(){

            @Override
            public void onBxmNoAd() {
                listener.onNoAd();
                BxmLoadAd.this.dialog = null;
            }

            @Override
            public void onBxmSuccess(Object o) {
                BxmLoadAd.this.canShow = true;
                BxmLoadAd.this.model.setBxmAd(BxmLoadAd.this.dialog);
                listener.onRequestSuccess();
            }

            @Override
            public void onBxmFailure(int code, String msg) {
                listener.onRequestFailure(2005, "");
                BxmLoadAd.this.dialog = null;
            }

            @Override
            public void onVideoComplete() {
                if (BxmLoadAd.this.canReturn()) {
                    listener.onVideoComplete();
                }
            }
        });
        this.dialog.show();
    }

    private void loadTtAd(final BxmAdNative.BxmVideoAdListener listener) {
        this.ttAdUtils.loadVideoAd("", 1, new BxmSdkListener(){

            @Override
            public void onBxmNoAd() {
            }

            @Override
            public void onBxmSuccess(Object o) {
                TTRewardVideoAd ad = (TTRewardVideoAd)o;
                BxmLoadAd.this.model.setTtAd(ad);
                if (BxmLoadAd.this.canReturn()) {
                    listener.onVideoComplete();
                }
            }

            @Override
            public void onBxmFailure(int code, String msg) {
            }

            @Override
            public void onVideoComplete() {
            }
        });
    }

    private boolean canReturn() {
        if (this.model == null) {
            return false;
        }
        return this.model.getBxmAd() != null || this.model.getTtAd() != null;
    }

    @Override
    public void showAd() {
        if (this.model == null) {
            return;
        }
        if (this.model.getType() == 0) {
            if (this.model.getTtAd() != null) {
                this.model.getTtAd().showRewardVideoAd(this.mActivity);
            } else if (this.model.getBxmAd() != null) {
                this.model.getBxmAd().show();
            }
        }
    }

    @Override
    public void registerDownloadListener() {
    }
}

