/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.update_app;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Environment;
import android.os.IBinder;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.bxm.ad.update_app.HttpManager;
import com.bxm.ad.update_app.UpdateAppBean;
import com.bxm.ad.update_app.listener.ExceptionHandler;
import com.bxm.ad.update_app.listener.ExceptionHandlerHelper;
import com.bxm.ad.update_app.listener.IUpdateDialogFragmentListener;
import com.bxm.ad.update_app.service.DownloadService;
import com.bxm.ad.update_app.utils.AppUpdateUtils;
import java.util.Map;

public class UpdateAppManager {
    static final String INTENT_KEY = "update_dialog_values";
    static final String THEME_KEY = "theme_color";
    static final String TOP_IMAGE_KEY = "top_resId";
    private static final String UPDATE_APP_KEY = "UPDATE_APP_KEY";
    private static final String TAG = UpdateAppManager.class.getSimpleName();
    private Map<String, String> mParams;
    private boolean mIgnoreDefParams = false;
    private Activity mActivity;
    private HttpManager mHttpManager;
    private String mUpdateUrl;
    private int mThemeColor;
    @DrawableRes
    private int mTopPic;
    private String mAppKey;
    private UpdateAppBean mUpdateApp;
    private String mTargetPath;
    private boolean isPost;
    private boolean mHideDialog;
    private boolean mShowIgnoreVersion;
    private boolean mDismissNotificationProgress;
    private boolean mOnlyWifi;
    private IUpdateDialogFragmentListener mUpdateDialogFragmentListener;

    private UpdateAppManager(Builder builder) {
        this.mActivity = builder.getActivity();
        this.mHttpManager = builder.getHttpManager();
        this.mUpdateUrl = builder.getUpdateUrl();
        this.mThemeColor = builder.getThemeColor();
        this.mTopPic = builder.getTopPic();
        this.mIgnoreDefParams = builder.isIgnoreDefParams();
        if (!this.mIgnoreDefParams) {
            this.mAppKey = builder.getAppKey();
        }
        this.mTargetPath = builder.getTargetPath();
        this.isPost = builder.isPost();
        this.mParams = builder.getParams();
        this.mHideDialog = builder.isHideDialog();
        this.mShowIgnoreVersion = builder.isShowIgnoreVersion();
        this.mDismissNotificationProgress = builder.isDismissNotificationProgress();
        this.mOnlyWifi = builder.isOnlyWifi();
        this.mUpdateDialogFragmentListener = builder.getUpdateDialogFragmentListener();
    }

    public static void download(Context context, final @NonNull UpdateAppBean updateAppBean, final @Nullable DownloadService.DownloadCallback downloadCallback) {
        if (updateAppBean == null) {
            throw new NullPointerException("updateApp \u4e0d\u80fd\u4e3a\u7a7a");
        }
        DownloadService.bindService(context.getApplicationContext(), new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder service) {
                ((DownloadService.DownloadBinder)service).start(updateAppBean, downloadCallback);
            }

            public void onServiceDisconnected(ComponentName name) {
            }
        });
    }

    public Context getContext() {
        return this.mActivity;
    }

    public void download(final @Nullable DownloadService.DownloadCallback downloadCallback) {
        if (this.mUpdateApp == null) {
            throw new NullPointerException("updateApp \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.mUpdateApp.setTargetPath(this.mTargetPath);
        this.mUpdateApp.setHttpManager(this.mHttpManager);
        DownloadService.bindService(this.mActivity.getApplicationContext(), new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder service) {
                ((DownloadService.DownloadBinder)service).start(UpdateAppManager.this.mUpdateApp, downloadCallback);
            }

            public void onServiceDisconnected(ComponentName name) {
            }
        });
    }

    public static class Builder {
        private Activity mActivity;
        private HttpManager mHttpManager;
        private String mUpdateUrl;
        private int mThemeColor = 0;
        @DrawableRes
        private int mTopPic = 0;
        private String mAppKey;
        private String mTargetPath;
        private boolean isPost;
        private Map<String, String> params;
        private boolean mIgnoreDefParams = false;
        private boolean mHideDialog = false;
        private boolean mShowIgnoreVersion;
        private boolean dismissNotificationProgress;
        private boolean mOnlyWifi;
        private IUpdateDialogFragmentListener mUpdateDialogFragmentListener;

        public Map<String, String> getParams() {
            return this.params;
        }

        public Builder setParams(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public boolean isIgnoreDefParams() {
            return this.mIgnoreDefParams;
        }

        public Builder setIgnoreDefParams(boolean ignoreDefParams) {
            this.mIgnoreDefParams = ignoreDefParams;
            return this;
        }

        public boolean isPost() {
            return this.isPost;
        }

        public Builder setPost(boolean post) {
            this.isPost = post;
            return this;
        }

        public String getTargetPath() {
            return this.mTargetPath;
        }

        public Builder setTargetPath(String targetPath) {
            this.mTargetPath = targetPath;
            return this;
        }

        public String getAppKey() {
            return this.mAppKey;
        }

        public Builder setAppKey(String appKey) {
            this.mAppKey = appKey;
            return this;
        }

        public Activity getActivity() {
            return this.mActivity;
        }

        public Builder setActivity(Activity activity) {
            this.mActivity = activity;
            return this;
        }

        public HttpManager getHttpManager() {
            return this.mHttpManager;
        }

        public Builder setHttpManager(HttpManager httpManager) {
            this.mHttpManager = httpManager;
            return this;
        }

        public String getUpdateUrl() {
            return this.mUpdateUrl;
        }

        public Builder setUpdateUrl(String updateUrl) {
            this.mUpdateUrl = updateUrl;
            return this;
        }

        public int getThemeColor() {
            return this.mThemeColor;
        }

        public Builder setThemeColor(int themeColor) {
            this.mThemeColor = themeColor;
            return this;
        }

        public int getTopPic() {
            return this.mTopPic;
        }

        public Builder setTopPic(int topPic) {
            this.mTopPic = topPic;
            return this;
        }

        public IUpdateDialogFragmentListener getUpdateDialogFragmentListener() {
            return this.mUpdateDialogFragmentListener;
        }

        public Builder setUpdateDialogFragmentListener(IUpdateDialogFragmentListener updateDialogFragmentListener) {
            this.mUpdateDialogFragmentListener = updateDialogFragmentListener;
            return this;
        }

        public UpdateAppManager build() {
            String appKey;
            if (this.getActivity() == null || this.getHttpManager() == null || TextUtils.isEmpty((CharSequence)this.getUpdateUrl())) {
                throw new NullPointerException("\u5fc5\u8981\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (TextUtils.isEmpty((CharSequence)this.getTargetPath())) {
                String path = "";
                if (Environment.getExternalStorageState().equals("mounted") || !Environment.isExternalStorageRemovable()) {
                    try {
                        path = this.getActivity().getExternalCacheDir().getAbsolutePath();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (TextUtils.isEmpty((CharSequence)path)) {
                        path = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getAbsolutePath();
                    }
                } else {
                    path = this.getActivity().getCacheDir().getAbsolutePath();
                }
                this.setTargetPath(path);
            }
            if (TextUtils.isEmpty((CharSequence)this.getAppKey()) && !TextUtils.isEmpty((CharSequence)(appKey = AppUpdateUtils.getManifestString((Context)this.getActivity(), UpdateAppManager.UPDATE_APP_KEY)))) {
                this.setAppKey(appKey);
            }
            return new UpdateAppManager(this);
        }

        public Builder hideDialogOnDownloading() {
            this.mHideDialog = true;
            return this;
        }

        public boolean isHideDialog() {
            return this.mHideDialog;
        }

        public Builder showIgnoreVersion() {
            this.mShowIgnoreVersion = true;
            return this;
        }

        public boolean isShowIgnoreVersion() {
            return this.mShowIgnoreVersion;
        }

        public Builder dismissNotificationProgress() {
            this.dismissNotificationProgress = true;
            return this;
        }

        public boolean isDismissNotificationProgress() {
            return this.dismissNotificationProgress;
        }

        public Builder setOnlyWifi() {
            this.mOnlyWifi = true;
            return this;
        }

        public boolean isOnlyWifi() {
            return this.mOnlyWifi;
        }

        public Builder handleException(ExceptionHandler exceptionHandler) {
            ExceptionHandlerHelper.init(exceptionHandler);
            return this;
        }
    }
}

