/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.update_app.service;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import android.widget.Toast;
import com.bxm.ad.update_app.HttpManager;
import com.bxm.ad.update_app.UpdateAppBean;
import com.bxm.ad.update_app.utils.AppUpdateUtils;
import com.bxm.ad.utils.SdkUtils;
import java.io.File;

public class DownloadService
extends Service {
    private static final int NOTIFY_ID = 1000;
    private static final String TAG = DownloadService.class.getSimpleName();
    private static final String CHANNEL_ID = "app_update_id";
    private static final CharSequence CHANNEL_NAME = "app_update_channel";
    public static boolean isRunning = false;
    private NotificationManager mNotificationManager;
    private DownloadBinder binder = new DownloadBinder();
    private NotificationCompat.Builder mBuilder;
    private boolean mDismissNotificationProgress = false;

    public static void bindService(Context context, ServiceConnection connection) {
        Intent intent = new Intent(context, DownloadService.class);
        context.startService(intent);
        context.bindService(intent, connection, 1);
        isRunning = true;
    }

    public boolean onUnbind(Intent intent) {
        isRunning = false;
        return super.onUnbind(intent);
    }

    public void onCreate() {
        super.onCreate();
        this.mNotificationManager = (NotificationManager)this.getSystemService("notification");
    }

    public IBinder onBind(Intent intent) {
        return this.binder;
    }

    public void onDestroy() {
        this.mNotificationManager = null;
        super.onDestroy();
    }

    private void setUpNotification() {
        if (this.mDismissNotificationProgress) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(CHANNEL_ID, CHANNEL_NAME, 4);
            channel.enableVibration(false);
            channel.enableLights(false);
            this.mNotificationManager.createNotificationChannel(channel);
        }
        this.mBuilder = new NotificationCompat.Builder((Context)this, CHANNEL_ID);
        this.mBuilder.setContentTitle((CharSequence)"\u5f00\u59cb\u4e0b\u8f7d").setContentText((CharSequence)"\u6b63\u5728\u8fde\u63a5\u670d\u52a1\u5668").setSmallIcon(SdkUtils.getIconId((Context)this)).setOngoing(true).setAutoCancel(true).setWhen(System.currentTimeMillis());
        this.mNotificationManager.notify(1000, this.mBuilder.build());
    }

    private void startDownload(UpdateAppBean updateApp, DownloadCallback callback) {
        this.mDismissNotificationProgress = updateApp.isDismissNotificationProgress();
        String apkUrl = updateApp.getApkFileUrl();
        if (TextUtils.isEmpty((CharSequence)apkUrl)) {
            String contentText = "\u65b0\u7248\u672c\u4e0b\u8f7d\u8def\u5f84\u9519\u8bef";
            this.stop(contentText);
            return;
        }
        String appName = AppUpdateUtils.getApkName(updateApp);
        File appDir = new File(updateApp.getTargetPath());
        if (!appDir.exists()) {
            appDir.mkdirs();
        }
        String target = appDir + File.separator + updateApp.getNewVersion();
        updateApp.getHttpManager().download(apkUrl, target, appName, new FileDownloadCallBack(callback));
    }

    private void stop(String contentText) {
        if (this.mBuilder != null) {
            this.mBuilder.setContentTitle((CharSequence)AppUpdateUtils.getAppName((Context)this)).setContentText((CharSequence)contentText);
            Notification notification = this.mBuilder.build();
            notification.flags = 16;
            this.mNotificationManager.notify(1000, notification);
        }
        this.close();
    }

    private void close() {
        this.stopSelf();
        isRunning = false;
    }

    class FileDownloadCallBack
    implements HttpManager.FileCallback {
        private final DownloadCallback mCallBack;
        int oldRate = 0;

        public FileDownloadCallBack(DownloadCallback callback) {
            this.mCallBack = callback;
        }

        @Override
        public void onBefore() {
            DownloadService.this.setUpNotification();
            if (this.mCallBack != null) {
                this.mCallBack.onStart();
            }
        }

        @Override
        public void onProgress(float progress, long total) {
            int rate = Math.round(progress * 100.0f);
            if (this.oldRate != rate) {
                if (this.mCallBack != null) {
                    this.mCallBack.setMax(total);
                    this.mCallBack.onProgress(progress, total);
                }
                if (DownloadService.this.mBuilder != null) {
                    DownloadService.this.mBuilder.setContentTitle((CharSequence)"\u6b63\u5728\u4e0b\u8f7d...").setContentText((CharSequence)(rate + "%")).setProgress(100, rate, false).setWhen(System.currentTimeMillis());
                    Notification notification = DownloadService.this.mBuilder.build();
                    notification.flags = 24;
                    DownloadService.this.mNotificationManager.notify(1000, notification);
                }
                this.oldRate = rate;
            }
        }

        @Override
        public void onError(String error) {
            Toast.makeText((Context)DownloadService.this, (CharSequence)("\u4e0b\u8f7d\u5931\u8d25" + error), (int)0).show();
            if (this.mCallBack != null) {
                this.mCallBack.onError(error);
            }
            try {
                DownloadService.this.mNotificationManager.cancel(1000);
                DownloadService.this.close();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResponse(File file) {
            if (this.mCallBack != null && !this.mCallBack.onFinish(file)) {
                DownloadService.this.close();
                return;
            }
            try {
                if (AppUpdateUtils.isAppOnForeground((Context)DownloadService.this) || DownloadService.this.mBuilder == null) {
                    DownloadService.this.mNotificationManager.cancel(1000);
                    if (this.mCallBack != null) {
                        boolean temp = this.mCallBack.onInstallAppAndAppOnForeground(file);
                        if (!temp) {
                            AppUpdateUtils.installApp((Context)DownloadService.this, file);
                        }
                    } else {
                        AppUpdateUtils.installApp((Context)DownloadService.this, file);
                    }
                } else {
                    Intent installAppIntent = AppUpdateUtils.getInstallAppIntent((Context)DownloadService.this, file);
                    PendingIntent contentIntent = PendingIntent.getActivity((Context)DownloadService.this, (int)0, (Intent)installAppIntent, (int)0x8000000);
                    DownloadService.this.mBuilder.setContentIntent(contentIntent).setContentTitle((CharSequence)AppUpdateUtils.getAppName((Context)DownloadService.this)).setContentText((CharSequence)"\u4e0b\u8f7d\u5b8c\u6210\uff0c\u8bf7\u70b9\u51fb\u5b89\u88c5").setProgress(0, 0, false).setDefaults(-1);
                    Notification notification = DownloadService.this.mBuilder.build();
                    notification.flags = 16;
                    DownloadService.this.mNotificationManager.notify(1000, notification);
                }
                DownloadService.this.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                DownloadService.this.close();
            }
        }
    }

    public class DownloadBinder
    extends Binder {
        public void start(UpdateAppBean updateApp, DownloadCallback callback) {
            DownloadService.this.startDownload(updateApp, callback);
        }

        public void stop(String msg) {
            DownloadService.this.stop(msg);
        }
    }

    public static interface DownloadCallback {
        public void onStart();

        public void onProgress(float var1, long var2);

        public void setMax(long var1);

        public boolean onFinish(File var1);

        public void onError(String var1);

        public boolean onInstallAppAndAppOnForeground(File var1);
    }
}

