/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.update_app.utils;

import android.content.res.ColorStateList;
import android.graphics.Color;
import java.util.Random;

public class ColorUtil {
    public static ColorStateList getColorStateList(int pressedColor, int normalColor) {
        return new ColorStateList((int[][])new int[][]{{16842910, 16842919}, {16842910}, new int[0]}, new int[]{pressedColor, normalColor, -1});
    }

    public static int colorDeep(int color2) {
        int alpha = Color.alpha((int)color2);
        int red = Color.red((int)color2);
        int green = Color.green((int)color2);
        int blue = Color.blue((int)color2);
        float ratio = 0.8f;
        red = (int)((float)red * ratio);
        green = (int)((float)green * ratio);
        blue = (int)((float)blue * ratio);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    public static boolean isTextColorDark(int color2) {
        float a = (float)Color.red((int)color2) * 0.299f + (float)Color.green((int)color2) * 0.587f + (float)Color.blue((int)color2) * 0.114f;
        return a > 180.0f;
    }

    public static int getRandomColor(int alpha, int lower, int upper) {
        return new RandomColor(alpha, lower, upper).getColor();
    }

    public static int getRandomColor() {
        return new RandomColor(255, 80, 200).getColor();
    }

    public static class RandomColor {
        int alpha;
        int lower;
        int upper;

        public RandomColor(int alpha, int lower, int upper) {
            if (upper <= lower) {
                throw new IllegalArgumentException("must be lower < upper");
            }
            this.setAlpha(alpha);
            this.setLower(lower);
            this.setUpper(upper);
        }

        public int getColor() {
            int red = this.getLower() + new Random().nextInt(this.getUpper() - this.getLower() + 1);
            int green = this.getLower() + new Random().nextInt(this.getUpper() - this.getLower() + 1);
            int blue = this.getLower() + new Random().nextInt(this.getUpper() - this.getLower() + 1);
            return Color.argb((int)this.getAlpha(), (int)red, (int)green, (int)blue);
        }

        public int getAlpha() {
            return this.alpha;
        }

        public void setAlpha(int alpha) {
            if (alpha > 255) {
                alpha = 255;
            }
            if (alpha < 0) {
                alpha = 0;
            }
            this.alpha = alpha;
        }

        public int getLower() {
            return this.lower;
        }

        public void setLower(int lower) {
            if (lower < 0) {
                lower = 0;
            }
            this.lower = lower;
        }

        public int getUpper() {
            return this.upper;
        }

        public void setUpper(int upper) {
            if (upper > 255) {
                upper = 255;
            }
            this.upper = upper;
        }
    }
}

