/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.utils;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.util.Property;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.TranslateAnimation;
import com.bxm.ad.utils.AppUtils;
import com.bxm.ad.utils.JumpInterpolator;

public class AnimationUtil {
    private static final String TAG = AnimationUtil.class.getSimpleName();

    public static TranslateAnimation moveToViewBottom() {
        TranslateAnimation mHiddenAction = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, 1.0f);
        mHiddenAction.setDuration(500L);
        return mHiddenAction;
    }

    public static TranslateAnimation moveToViewLocation() {
        TranslateAnimation mHiddenAction = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 1.0f, 1, 0.0f);
        mHiddenAction.setDuration(5000L);
        return mHiddenAction;
    }

    public static void startShakeByPropertyAnim(View view) {
        if (view == null) {
            return;
        }
        float scaleSmall = 0.9f;
        float scaleLarge = 1.1f;
        float shakeDegrees = 10.0f;
        long duration = 1000L;
        PropertyValuesHolder scaleXValuesHolder = PropertyValuesHolder.ofKeyframe((Property)View.SCALE_X, (Keyframe[])new Keyframe[]{Keyframe.ofFloat((float)0.0f, (float)1.0f), Keyframe.ofFloat((float)0.25f, (float)scaleSmall), Keyframe.ofFloat((float)0.5f, (float)scaleLarge), Keyframe.ofFloat((float)0.75f, (float)scaleLarge), Keyframe.ofFloat((float)1.0f, (float)1.0f)});
        PropertyValuesHolder scaleYValuesHolder = PropertyValuesHolder.ofKeyframe((Property)View.SCALE_Y, (Keyframe[])new Keyframe[]{Keyframe.ofFloat((float)0.0f, (float)1.0f), Keyframe.ofFloat((float)0.25f, (float)scaleSmall), Keyframe.ofFloat((float)0.5f, (float)scaleLarge), Keyframe.ofFloat((float)0.75f, (float)scaleLarge), Keyframe.ofFloat((float)1.0f, (float)1.0f)});
        PropertyValuesHolder rotateValuesHolder = PropertyValuesHolder.ofKeyframe((Property)View.ROTATION, (Keyframe[])new Keyframe[]{Keyframe.ofFloat((float)0.0f, (float)0.0f), Keyframe.ofFloat((float)0.1f, (float)(-shakeDegrees)), Keyframe.ofFloat((float)0.2f, (float)shakeDegrees), Keyframe.ofFloat((float)0.3f, (float)(-shakeDegrees)), Keyframe.ofFloat((float)0.4f, (float)shakeDegrees), Keyframe.ofFloat((float)0.5f, (float)(-shakeDegrees)), Keyframe.ofFloat((float)0.6f, (float)shakeDegrees), Keyframe.ofFloat((float)0.7f, (float)(-shakeDegrees)), Keyframe.ofFloat((float)0.8f, (float)shakeDegrees), Keyframe.ofFloat((float)0.9f, (float)(-shakeDegrees)), Keyframe.ofFloat((float)1.0f, (float)0.0f)});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleXValuesHolder, scaleYValuesHolder, rotateValuesHolder});
        objectAnimator.setDuration(duration);
        objectAnimator.start();
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{0.0f, 0.0f});
        animator.setDuration(3000L);
        final AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playSequentially(new Animator[]{objectAnimator, animator});
        animatorSet.start();
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                animatorSet.start();
            }
        });
    }

    public static void startAnimTranslationX(final View mView) {
        ViewTreeObserver mViewTreeObserver = mView.getViewTreeObserver();
        mViewTreeObserver.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                int[] location = new int[2];
                mView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                int width = AppUtils.getAppWidth(mView.getContext());
                int viewWidth = mView.getMeasuredWidth();
                mView.getLocationOnScreen(location);
                int startX = location[0];
                ObjectAnimator anim2 = ObjectAnimator.ofFloat((Object)mView, (String)"translationX", (float[])new float[]{0.0f, -startX});
                anim2.setInterpolator((TimeInterpolator)new JumpInterpolator());
                anim2.setDuration(2500L);
                ObjectAnimator anim1 = ObjectAnimator.ofFloat((Object)mView, (String)"translationX", (float[])new float[]{-startX, 0.0f});
                anim1.setInterpolator((TimeInterpolator)new JumpInterpolator());
                anim1.setDuration(2500L);
                AnimatorSet animSet = new AnimatorSet();
                animSet.playSequentially(new Animator[]{anim2, anim1});
                animSet.start();
                return false;
            }
        });
    }
}

