/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.utils;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v7.app.AppCompatActivity;
import android.util.DisplayMetrics;
import android.view.View;
import java.lang.reflect.Method;

public class AppUtils {
    public static boolean isVisible(View var0) {
        Rect rect = new Rect();
        var0.getLocalVisibleRect(rect);
        return rect.top == 0;
    }

    public static boolean isNetworkAvailable(Context context) {
        NetworkInfo info;
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        return connectivity != null && (info = connectivity.getActiveNetworkInfo()) != null && info.isConnected() && info.getState() == NetworkInfo.State.CONNECTED;
    }

    public static int[] getAppSize(Context context) {
        int[] size = new int[2];
        DisplayMetrics metrics = AppUtils.getDisplayMetrics(context);
        size[0] = metrics.widthPixels;
        size[1] = metrics.heightPixels;
        return size;
    }

    public static int getAppWidth(Context context) {
        int[] size = new int[2];
        DisplayMetrics metrics = AppUtils.getDisplayMetrics(context);
        size[0] = metrics.widthPixels;
        size[1] = metrics.heightPixels;
        return metrics.widthPixels;
    }

    public static int getAppHight(Context context) {
        int[] size = new int[2];
        DisplayMetrics metrics = AppUtils.getDisplayMetrics(context);
        size[0] = metrics.widthPixels;
        size[1] = metrics.heightPixels;
        return metrics.heightPixels;
    }

    public static int[] getScreenSize(AppCompatActivity activity) {
        int[] size = new int[2];
        View decorView = activity.getWindow().getDecorView();
        size[0] = decorView.getWidth();
        size[1] = decorView.getHeight();
        return size;
    }

    public static int getStatusBarHeight(Context context) {
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        return resources.getDimensionPixelSize(resourceId);
    }

    public static int getNavigationBarHeight(Context context) {
        int navigationBarHeight = 0;
        Resources rs = context.getResources();
        int id2 = rs.getIdentifier("navigation_bar_height", "dimen", "android");
        if (id2 > 0 && AppUtils.hasNavigationBar(context)) {
            navigationBarHeight = rs.getDimensionPixelSize(id2);
        }
        return navigationBarHeight;
    }

    private static boolean hasNavigationBar(Context context) {
        boolean hasNavigationBar = false;
        Resources rs = context.getResources();
        int id2 = rs.getIdentifier("config_showNavigationBar", "bool", "android");
        if (id2 > 0) {
            hasNavigationBar = rs.getBoolean(id2);
        }
        try {
            Class<?> systemPropertiesClass = Class.forName("android.os.SystemProperties");
            Method m = systemPropertiesClass.getMethod("get", String.class);
            String navBarOverride = (String)m.invoke(systemPropertiesClass, "qemu.hw.mainkeys");
            if ("1".equals(navBarOverride)) {
                hasNavigationBar = false;
            } else if ("0".equals(navBarOverride)) {
                hasNavigationBar = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hasNavigationBar;
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return metrics;
    }

    public static void copyTextToSystem(Context context, String text) {
        ClipboardManager cm = (ClipboardManager)context.getSystemService("clipboard");
        ClipData mClipData = ClipData.newPlainText((CharSequence)"Label", (CharSequence)text);
        cm.setPrimaryClip(mClipData);
    }
}

