/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.utils;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.bxm.ad.api.ApiHelper;
import com.bxm.ad.api.BxmCallBack;
import com.bxm.ad.api.RtCallback;
import com.bxm.ad.model.BxmModel;
import com.bxm.ad.utils.DataUtils;
import com.bxm.ad.utils.LogUtil;
import com.google.gson.Gson;
import java.net.HttpURLConnection;
import java.net.URL;
import okhttp3.FormBody;
import okhttp3.RequestBody;
import org.json.JSONObject;
import retrofit2.Callback;

public class BuryUtils {
    public static void addBuryLogInfo(Context context, final String mt, BxmModel model) {
        FormBody requestBody = DataUtils.getBuryData(context, mt, model);
        LogUtil.i("mt ---" + new Gson().toJson((Object)requestBody));
        final long starTime = System.currentTimeMillis();
        ApiHelper.exApi().rewardCountInfo((RequestBody)requestBody).enqueue((Callback)new RtCallback<String>(){

            @Override
            public void onRtResponse(String s) {
                LogUtil.i("mt ---" + mt + "onRtResponse ==" + s);
                long end = System.currentTimeMillis();
                LogUtil.i("mt ---" + mt + "time ==" + (end - starTime));
            }

            @Override
            public void onRtFailure(int code, String errmsg) {
                LogUtil.i("mt ==" + mt + "   type ==  --- code == " + code + "---onRtFailure() = " + errmsg);
                long end = System.currentTimeMillis();
                LogUtil.i("errmsg ---" + errmsg + "time ==" + (end - starTime));
            }
        });
    }

    public static void getOrderId(Context context, final String mt, BxmModel model, final BxmCallBack callBack) {
        FormBody requestBody = DataUtils.getBuryData(context, mt, model);
        final long starTime = System.currentTimeMillis();
        ApiHelper.exApi().rewardCountInfo((RequestBody)requestBody).enqueue((Callback)new RtCallback<String>(){

            @Override
            public void onRtResponse(String s) {
                long end = System.currentTimeMillis();
                LogUtil.i("mt ---" + mt + "time ==" + (end - starTime));
                LogUtil.i("onRtResponse ==" + s);
                try {
                    JSONObject json = new JSONObject(s);
                    String orderId = json.getString("data");
                    boolean isOk = json.getBoolean("success");
                    if (isOk && !TextUtils.isEmpty((CharSequence)orderId)) {
                        callBack.onComplete(orderId);
                    } else {
                        callBack.onFail();
                    }
                }
                catch (Exception ex) {
                    callBack.onFail();
                }
            }

            @Override
            public void onRtFailure(int code, String errmsg) {
                LogUtil.i("mt ==" + mt + "   type ==  --- code == " + code + "---onRtFailure() = " + errmsg);
                callBack.onFail();
                long end = System.currentTimeMillis();
                LogUtil.i("errmsg ---" + errmsg + "time ==" + (end - starTime));
            }
        });
    }

    public static void addAdInstall(Context context, final String mt) {
        FormBody requestBody = DataUtils.install(context, mt);
        ApiHelper.exApi().rewardCountInfo((RequestBody)requestBody).enqueue((Callback)new RtCallback<String>(){

            @Override
            public void onRtResponse(String s) {
                LogUtil.i("mt ---" + mt + "onRtResponse ==" + s);
            }

            @Override
            public void onRtFailure(int code, String errmsg) {
                LogUtil.i("type ==  --- code == " + code + "---onRtFailure() = " + errmsg);
            }
        });
    }

    public static void activeUrl(String path) {
        HttpURLConnection urlConn = null;
        try {
            URL url = new URL(path);
            urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setConnectTimeout(5000);
            urlConn.setReadTimeout(5000);
            urlConn.setRequestMethod("GET");
            urlConn.setRequestProperty("Content-Type", "application/json");
            urlConn.addRequestProperty("Connection", "Keep-Alive");
            urlConn.connect();
            if (urlConn.getResponseCode() == 200) {
                Log.i((String)"HttpURLConnection == ", (String)("-------" + urlConn.getResponseMessage()));
            } else {
                Log.i((String)"HttpURLConnection == ", (String)("-------" + urlConn.getResponseMessage()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (urlConn != null) {
                urlConn.disconnect();
            }
        }
    }
}

