/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.utils;

import android.content.Context;
import android.text.TextUtils;
import com.bxm.ad.model.BuryModel;
import com.bxm.ad.model.BxmCheckModel;
import com.bxm.ad.model.BxmModel;
import com.bxm.ad.utils.LocationUtils;
import com.bxm.ad.utils.PackageUtils;
import com.bxm.ad.utils.SdkUtils;
import com.bxm.ad.utils.ShareUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import okhttp3.FormBody;

public class DataUtils {
    public static BxmModel getShowAd(Context context, List<BxmModel> modelList) {
        BxmModel model = null;
        Iterator<BxmModel> it = modelList.iterator();
        while (it.hasNext()) {
            BxmModel mo = it.next();
            if (!DataUtils.isAppInstalled(context, mo.getPackage_name())) continue;
            it.remove();
        }
        if (modelList.size() == 0) {
            return null;
        }
        for (int i = 0; i < modelList.size(); ++i) {
            BxmModel m = modelList.get(i);
            if (DataUtils.isAppInstalled(context, m.getPackage_name())) continue;
            int type = m.getUse_type();
            if (type == 0 || type == 1) {
                if (!DataUtils.isAdExposure(m)) {
                    model = m;
                    break;
                }
                if (i != modelList.size() - 1) continue;
                model = modelList.get(0);
                continue;
            }
            model = m;
            break;
        }
        return model;
    }

    private static boolean isAdExposure(BxmModel bxmModel) {
        block6: {
            if (bxmModel == null || TextUtils.isEmpty((CharSequence)bxmModel.getId())) {
                return false;
            }
            String json = ShareUtil.getString("bxm_exposure_ad_list");
            if (TextUtils.isEmpty((CharSequence)json)) {
                return false;
            }
            try {
                List list = (List)new Gson().fromJson(json, new TypeToken<List<BxmModel>>(){}.getType());
                if (list != null && list.size() > 0) {
                    for (BxmModel o : list) {
                        if (!o.getId().equals(bxmModel.getId())) continue;
                        return true;
                    }
                    break block6;
                }
                return false;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    public static List<BxmCheckModel> getBxmCheck() {
        ArrayList<BxmCheckModel> list;
        block5: {
            list = new ArrayList<BxmCheckModel>();
            String json = ShareUtil.getString("bxm_exposure_ad_list");
            if (TextUtils.isEmpty((CharSequence)json)) {
                return null;
            }
            try {
                List models = (List)new Gson().fromJson(json, new TypeToken<List<BxmModel>>(){}.getType());
                if (models != null && models.size() > 0) {
                    for (BxmModel b : models) {
                        BxmCheckModel checkModel = new BxmCheckModel();
                        checkModel.setTicket_id(b.getId());
                        checkModel.setUse_type(b.getUse_type() + "");
                        checkModel.setCoupons_code(b.getCoupons_code());
                        list.add(checkModel);
                    }
                    break block5;
                }
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }
        return list;
    }

    public static void clearData(List<BxmCheckModel> checkModels) {
        String json = ShareUtil.getString("bxm_exposure_ad_list");
        if (TextUtils.isEmpty((CharSequence)json)) {
            return;
        }
        try {
            List list = (List)new Gson().fromJson(json, new TypeToken<List<BxmModel>>(){}.getType());
            if (list != null && list.size() > 0) {
                for (BxmCheckModel m : checkModels) {
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        BxmModel mo = (BxmModel)it.next();
                        if (!m.getTicket_id().equals(mo.getId()) || !m.getCoupons_code().equals(mo.getCoupons_code())) continue;
                        it.remove();
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static boolean isAppInstalled(Context context, String pageName) {
        try {
            PackageUtils utils = new PackageUtils(context);
            PackageUtils.AllPackageInfos infos = utils.getAllPackageInfos();
            for (PackageUtils.AllPackageInfo app : infos.getInfos()) {
                if (!app.getPackageName().equals(pageName)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String getApplist(Context context) {
        if (ShareUtil.getBoolean("bxm_app_list")) {
            return "";
        }
        ShareUtil.putBoolean("bxm_app_list", true);
        try {
            PackageUtils utils = new PackageUtils(context);
            PackageUtils.AllPackageInfos infos = utils.getAllPackageInfos();
            if (infos == null) {
                return "";
            }
            return new Gson().toJson((Object)infos);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static void joinNativieExposure(BxmModel bxmModel) {
        if (bxmModel == null || TextUtils.isEmpty((CharSequence)bxmModel.getId())) {
            return;
        }
        String json = ShareUtil.getString("bxm_exposure_ad_list");
        if (TextUtils.isEmpty((CharSequence)json)) {
            ArrayList<BxmModel> bxmModels = new ArrayList<BxmModel>();
            bxmModels.add(bxmModel);
            ShareUtil.putString("bxm_exposure_ad_list", new Gson().toJson(bxmModels));
        } else {
            try {
                List list = (List)new Gson().fromJson(json, new TypeToken<List<BxmModel>>(){}.getType());
                if (list != null && list.size() > 0) {
                    for (BxmModel o : list) {
                        if (!o.getId().equals(bxmModel.getId())) continue;
                        list.remove(o);
                    }
                    list.add(0, bxmModel);
                    ShareUtil.putString("bxm_exposure_ad_list", new Gson().toJson((Object)list));
                } else {
                    ArrayList<BxmModel> bxmModels = new ArrayList<BxmModel>();
                    bxmModels.add(bxmModel);
                    ShareUtil.putString("bxm_exposure_ad_list", new Gson().toJson((Object)bxmModel));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static FormBody getBuryData(Context context, String mt, BxmModel model) {
        return new FormBody.Builder().add("countId", (model.getCountId() + "").replace("null", "")).add("appkey", SdkUtils.getPosKey(model.getPosId()) + "").add("business", SdkUtils.getBis(model.getPosId()) + "").add("timestamp", SdkUtils.timeStamp() + "").add("spm", model.getReqId() + "").add("uid", SdkUtils.getIMEI(context) + "").add("appos", "1").add("modeltype", mt).add("preid", model.getId()).add("awardtype", "2").add("i", SdkUtils.getIMEI(context)).add("useType", model.getUse_type() + "").add("couponsCode", model.getCoupons_code()).add("ticketType", "4").add("apposVersion", SdkUtils.getBuildVersion() + "").add("devm", (SdkUtils.getPhoneModel() + "").replace("null", "")).add("pkn", SdkUtils.getPackageName(context) + "").add("cx", LocationUtils.getCx(context) + "").add("cy", LocationUtils.getCY(context) + "").add("adurl", model.getIcon_img()).add("fmid", model.getIcon_id()).add("isp", SdkUtils.getOperators(context)).add("appl", DataUtils.getApplist(context)).add("appv", SdkUtils.getVersionName(context)).add("ds", SdkUtils.getIMEI(context)).build();
    }

    public static BuryModel adRequest(Context context, String reqid, String posId, String adId, String fid, String adUrl) {
        return new BuryModel.Builder().requestId(reqid).posId(posId).timeStamp(SdkUtils.timeStamp()).deviceId(SdkUtils.getIMEI(context)).deviceType("android").deviceModel(SdkUtils.getPhoneModel()).os(SdkUtils.getBuildVersion()).isp(SdkUtils.getOperators(context)).appv(SdkUtils.getVersionName(context)).hostAppId(SdkUtils.getPackageName(context)).latX(LocationUtils.getCx(context)).lonY(LocationUtils.getCY(context)).adId(adId).adUrl(fid).adImgUrl(adUrl).build();
    }

    public static FormBody install(Context context, String mt) {
        return new FormBody.Builder().add("countId", "0").add("appkey", SdkUtils.getPosKey("fbca14bb5bb74d5a9b5fa165ad78a15a-20")).add("business", SdkUtils.getPosKey("fbca14bb5bb74d5a9b5fa165ad78a15a-20") + "").add("timestamp", SdkUtils.timeStamp() + "").add("uid", SdkUtils.getIMEI(context) + "").add("appos", "1").add("modeltype", mt).add("awardtype", "2").add("i", SdkUtils.getIMEI(context)).add("ticketType", "4").add("apposVersion", SdkUtils.getBuildVersion() + "").add("devm", (SdkUtils.getPhoneModel() + "").replace("null", "")).add("pkn", SdkUtils.getPackageName(context) + "").add("cx", LocationUtils.getCx(context) + "").add("cy", LocationUtils.getCY(context) + "").add("isp", SdkUtils.getOperators(context)).add("appl", DataUtils.getApplist(context)).add("appv", SdkUtils.getVersionName(context)).add("ds", SdkUtils.getIMEI(context)).add("hostAppId", SdkUtils.getPackageName(context)).build();
    }

    public static String getStringUrl(String url, Context context, String reqid, String posId, String adId, String fid, String adUrl) {
        String link = url.replace("%%reqId%%", reqid + "").replace("%%bxmid%%", reqid + "").replace("%%posid%%", posId + "").replace("%%t%%", SdkUtils.timeStamp() + "").replace("%%devid%%", SdkUtils.getIMEI(context) + "").replace("%%devt%%", "android").replace("%%devm%%", SdkUtils.getPhoneModel() + "").replace("%%os%%", SdkUtils.getBuildVersion() + "").replace("%%pkn%%", SdkUtils.getPackageName(context) + "").replace("%%cy%%", LocationUtils.getCY(context) + "").replace("%%cx%%", LocationUtils.getCx(context) + "").replace("%%shid%%", adId + "").replace("%%adurl%%", adUrl + "").replace("%%fmid%%", fid + "").replace("%%isp%%", SdkUtils.getOperators(context) + "").replace("%%appv%%", SdkUtils.getVersionName(context) + "").replace("%%ds%%", SdkUtils.getIMEI(context) + "");
        return link;
    }
}

