/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.utils;

import android.text.TextUtils;
import com.bxm.ad.NativeDataCallBack;
import com.bxm.ad.model.BxmModel;
import com.bxm.ad.utils.SdkUtils;
import com.bxm.ad.utils.ShareUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;

public class LoadNativeDataUtils {
    public static void loadLastData(String key, NativeDataCallBack listener) {
        String json = ShareUtil.getString(key);
        if (TextUtils.isEmpty((CharSequence)json)) {
            if (listener != null) {
                listener.onNativeNoData();
            }
            return;
        }
        ArrayList<BxmModel> models = new ArrayList<BxmModel>();
        try {
            List list = (List)new Gson().fromJson(json, new TypeToken<List<BxmModel>>(){}.getType());
            if (list != null && list.size() > 0) {
                for (BxmModel o : list) {
                    if (!SdkUtils.timeCompare(o.getValidEndDate()) || SdkUtils.timeCompare(o.getValidStartDate())) continue;
                    models.add(o);
                }
                listener.onNativeData(models);
            } else {
                listener.onNativeNoData();
            }
        }
        catch (Exception ex) {
            listener.onNativeNoData();
        }
    }
}

