/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.utils;

import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import com.bxm.ad.utils.LogUtil;

public class LocationUtils {
    private static double latitude = 0.0;
    private static double longitude = 0.0;

    public static void getGps(Context context) {
        LocationManager locationManager = (LocationManager)context.getSystemService("location");
        if (locationManager.isProviderEnabled("gps")) {
            if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                LogUtil.i("\u6ca1\u6709\u5b9a\u4f4d\u6743\u9650");
                return;
            }
            Location location = locationManager.getLastKnownLocation("gps");
            if (location != null) {
                latitude = location.getLatitude();
                longitude = location.getLongitude();
            }
        } else {
            LocationListener locationListener = new LocationListener(){

                public void onStatusChanged(String provider, int status, Bundle extras) {
                }

                public void onProviderEnabled(String provider) {
                }

                public void onProviderDisabled(String provider) {
                }

                public void onLocationChanged(Location location) {
                    if (location != null) {
                        Log.e((String)"Map", (String)("Location changed : Lat: " + location.getLatitude() + " Lng: " + location.getLongitude()));
                    }
                }
            };
            locationManager.requestLocationUpdates("network", 1000L, 0.0f, locationListener);
            Location location = locationManager.getLastKnownLocation("network");
            if (location != null) {
                latitude = location.getLatitude();
                longitude = location.getLongitude();
            }
        }
    }

    public static String getCx(Context context) {
        LocationManager lm = (LocationManager)context.getSystemService("location");
        Criteria criteria = new Criteria();
        criteria.setCostAllowed(false);
        criteria.setAccuracy(2);
        String providerName = lm.getBestProvider(criteria, true);
        if (providerName != null) {
            if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                return "";
            }
            Location location = lm.getLastKnownLocation(providerName);
            if (location != null) {
                double longitude = location.getLongitude();
                return longitude + "";
            }
        }
        return "";
    }

    public static String getCY(Context context) {
        LocationManager lm = (LocationManager)context.getSystemService("location");
        Criteria criteria = new Criteria();
        criteria.setCostAllowed(false);
        criteria.setAccuracy(2);
        String providerName = lm.getBestProvider(criteria, true);
        if (providerName != null) {
            if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                return "";
            }
            Location location = lm.getLastKnownLocation(providerName);
            if (location != null) {
                double latitude = location.getLatitude();
                return latitude + "";
            }
        }
        return "";
    }
}

