/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class PackageUtils {
    private Context context;

    public PackageUtils(Context context) {
        this.context = context;
    }

    public List<PackageInfo> getPackageInfos() {
        PackageManager packageManager = this.context.getPackageManager();
        return packageManager.getInstalledPackages(0);
    }

    public AllPackageInfos getAllPackageInfos() {
        PackageManager packageManager = this.context.getPackageManager();
        AllPackageInfos infos = new AllPackageInfos();
        for (PackageInfo info : this.getPackageInfos()) {
            if ((1 & info.applicationInfo.flags) != 0) continue;
            AllPackageInfo aInfo = new AllPackageInfo();
            aInfo.setVersionName(info.versionName);
            aInfo.setVersionCode(info.versionCode);
            aInfo.setPackageName(info.packageName);
            aInfo.setFirstInstallTime(info.firstInstallTime);
            aInfo.setLastUpdateTime(info.lastUpdateTime);
            aInfo.setName(packageManager.getApplicationLabel(info.applicationInfo).toString());
            infos.add(aInfo);
        }
        return infos;
    }

    public String getAllPackageInfo() {
        Gson gson = new Gson();
        try {
            Type founderListType = new TypeToken<AllPackageInfos>(){}.getType();
            String infoJson = gson.toJson((Object)this.getAllPackageInfos(), founderListType);
            return infoJson;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String stampToDate(long time) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
        Date date = new Date(time);
        String res = simpleDateFormat.format(date);
        return res;
    }

    class AllPackageInfo {
        private String versionName;
        private String name;
        private int versionCode;
        private String packageName;
        private boolean system;
        private String firstInstallTime;
        private String lastUpdateTime;

        AllPackageInfo() {
        }

        public boolean isSystem() {
            return this.system;
        }

        public void setSystem(boolean system) {
            this.system = system;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersionName() {
            return this.versionName;
        }

        public void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        public int getVersionCode() {
            return this.versionCode;
        }

        public void setVersionCode(int versionCode) {
            this.versionCode = versionCode;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getFirstInstallTime() {
            return this.firstInstallTime;
        }

        public void setFirstInstallTime(long firstInstallTime) {
            this.firstInstallTime = PackageUtils.stampToDate(firstInstallTime);
        }

        public String getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public void setLastUpdateTime(long lastUpdateTime) {
            this.lastUpdateTime = PackageUtils.stampToDate(lastUpdateTime);
        }
    }

    class AllPackageInfos {
        private List<AllPackageInfo> packageInfos = new ArrayList<AllPackageInfo>();

        public List<AllPackageInfo> getInfos() {
            return this.packageInfos;
        }

        public void add(AllPackageInfo allPackageInfo) {
            this.packageInfos.add(allPackageInfo);
        }
    }
}

