/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.ad.utils;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.bxm.ad.utils.PackageUtils;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.NetworkInterface;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class SdkUtils {
    public static final String ERROR_MAC_STR = "02:00:00:00:00:00";
    private String sdcard = Environment.getExternalStorageState();
    private String state = "mounted";
    private File file = Environment.getExternalStorageDirectory();
    private StatFs statFs = new StatFs(this.file.getPath());

    public static String getOperators(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        String operator = "";
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return "";
        }
        String IMSI = tm.getSubscriberId();
        if (IMSI == null || IMSI.equals("")) {
            return operator;
        }
        operator = IMSI.startsWith("46000") || IMSI.startsWith("46002") ? "\u4e2d\u56fd\u79fb\u52a8" : (IMSI.startsWith("46001") ? "\u4e2d\u56fd\u8054\u901a" : (IMSI.startsWith("46003") ? "\u4e2d\u56fd\u7535\u4fe1" : "\u672a\u77e5"));
        return operator;
    }

    public static String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getMacDefault(Context context) {
        String mac = "";
        if (context == null) {
            return mac;
        }
        WifiManager wifi = (WifiManager)context.getSystemService("wifi");
        WifiInfo info = null;
        try {
            info = wifi.getConnectionInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (info == null) {
            return null;
        }
        mac = info.getMacAddress();
        if (!TextUtils.isEmpty((CharSequence)mac)) {
            mac = mac.toUpperCase(Locale.ENGLISH);
        }
        return mac;
    }

    public static String getMacAddress() {
        String macSerial = null;
        String str = "";
        try {
            Process pp = Runtime.getRuntime().exec("cat/sys/class/net/wlan0/address");
            InputStreamReader ir = new InputStreamReader(pp.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (null != str) {
                str = input.readLine();
                if (str == null) continue;
                macSerial = str.trim();
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return macSerial;
    }

    public static String getMacFromHardware() {
        try {
            ArrayList<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                if (!nif.getName().equalsIgnoreCase("wlan0")) continue;
                byte[] macBytes = nif.getHardwareAddress();
                if (macBytes == null) {
                    return "";
                }
                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02X:", b));
                }
                if (res1.length() > 0) {
                    res1.deleteCharAt(res1.length() - 1);
                }
                return res1.toString();
            }
        }
        catch (Exception e) {
            Log.e((String)"mac", (String)("get android version 7.0 mac error:" + e.getMessage()));
        }
        return ERROR_MAC_STR;
    }

    public static String getMac(Context context) {
        String mac = "";
        mac = Build.VERSION.SDK_INT < 23 ? SdkUtils.getMacDefault(context) : (Build.VERSION.SDK_INT < 24 ? SdkUtils.getMacAddress() : SdkUtils.getMacFromHardware());
        return mac;
    }

    public static String getAppList(Context context) {
        PackageUtils utils = new PackageUtils(context);
        PackageUtils.AllPackageInfos infos = utils.getAllPackageInfos();
        return new Gson().toJson((Object)infos);
    }

    public static String getStory() {
        try {
            StatFs sf = new StatFs(Environment.getExternalStorageDirectory().getAbsolutePath());
            if (Build.VERSION.SDK_INT >= 18) {
                long totalSize = sf.getTotalBytes();
                return totalSize / 0x100000L + "";
            }
            return "0";
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String getMemory(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        int memory = activityManager.getMemoryClass();
        System.out.println("memory: " + memory);
        float maxMemory = (float)((double)Runtime.getRuntime().maxMemory() * 1.0 / 1048576.0);
        float totalMemory = (float)((double)Runtime.getRuntime().totalMemory() * 1.0 / 1048576.0);
        float freeMemory = (float)((double)Runtime.getRuntime().freeMemory() * 1.0 / 1048576.0);
        return totalMemory + "";
    }

    public static String getCpuType() {
        return Build.CPU_ABI;
    }

    public static String getIMEI(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return androidId;
    }

    public static String getAndroidId(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return androidId;
    }

    public static String getPhoneBrand() {
        return Build.BRAND;
    }

    public static String getPhoneModel() {
        return Build.MODEL;
    }

    public static int getBuildLevel() {
        return Build.VERSION.SDK_INT;
    }

    public static String getBuildVersion() {
        return Build.VERSION.RELEASE;
    }

    public static int getAppProcessId() {
        return android.os.Process.myPid();
    }

    public static String getAppProcessName(Context context, int processId) {
        String processName = null;
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List l = am.getRunningAppProcesses();
        Iterator i = l.iterator();
        PackageManager pm = context.getPackageManager();
        while (i.hasNext()) {
            ActivityManager.RunningAppProcessInfo info = (ActivityManager.RunningAppProcessInfo)i.next();
            try {
                if (info.pid != processId) continue;
                CharSequence c = pm.getApplicationLabel(pm.getApplicationInfo(info.processName, 128));
                processName = info.processName;
                return processName;
            }
            catch (Exception e) {
                Log.e((String)"", (String)e.getMessage(), (Throwable)e);
            }
        }
        return processName;
    }

    private long getAvailableSize() {
        if (this.sdcard.equals(this.state)) {
            long blockSize = this.statFs.getBlockSize();
            long blockavailable = this.statFs.getAvailableBlocks();
            long blockavailableTotal = blockSize * blockavailable / 1000L / 1000L;
            return blockavailableTotal;
        }
        return -1L;
    }

    public static String getDeviceSN() {
        String serialNumber = Build.SERIAL;
        return serialNumber;
    }

    public static synchronized String getPackageName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.packageName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static int getIconId(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo info = pm.getPackageInfo(context.getPackageName(), 0);
            return info.applicationInfo.icon;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static String intIP2StringIP(int ip) {
        return (ip & 0xFF) + "." + (ip >> 8 & 0xFF) + "." + (ip >> 16 & 0xFF) + "." + (ip >> 24 & 0xFF);
    }

    public static String timeStamp() {
        return System.currentTimeMillis() + "";
    }

    public static String getUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }

    public static String getPosKey(String posId) {
        String[] a = new String[2];
        a = posId.split("-");
        if (a.length > 0) {
            return a[0];
        }
        return "";
    }

    public static String getBis(String posId) {
        String[] a = new String[2];
        a = posId.split("-");
        if (a.length > 0) {
            return a[1];
        }
        return "";
    }

    public static boolean timeCompare(String endTime) {
        boolean i = false;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        try {
            Date date1 = new Date(System.currentTimeMillis());
            Date date2 = dateFormat.parse(endTime);
            if (date2.getTime() <= date1.getTime()) {
                return false;
            }
            if (date2.getTime() > date1.getTime()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String getVersionName(Context context) {
        return SdkUtils.getPackageInfo((Context)context).versionName;
    }

    public static int getVersionCode(Context context) {
        return SdkUtils.getPackageInfo((Context)context).versionCode;
    }

    private static PackageInfo getPackageInfo(Context context) {
        PackageInfo pInfo = null;
        try {
            PackageManager pManager = context.getPackageManager();
            pInfo = pManager.getPackageInfo(context.getPackageName(), 16384);
            return pInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return pInfo;
        }
    }

    public static HashMap<String, String> getInitData(Context context, String key) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("deviceid", SdkUtils.getIMEI(context));
        map.put("imei", SdkUtils.getIMEI(context));
        map.put("mac", SdkUtils.getMac(context));
        map.put("equipmentModel", SdkUtils.getPhoneModel());
        map.put("equipmentBrand", SdkUtils.getPhoneBrand());
        map.put("memory", SdkUtils.getMemory(context));
        map.put("storageSpace", SdkUtils.getStory());
        map.put("cpuModel", SdkUtils.getCpuType());
        map.put("systemVersion", SdkUtils.getSystemVersion());
        map.put("packageName", SdkUtils.getPackageName(context));
        map.put("networkOperator", SdkUtils.getOperators(context));
        map.put("sdkVersion", "1.0.0");
        map.put("appkey", key);
        map.put("applications", SdkUtils.getAppList(context));
        map.put("equipmentType", "1");
        return map;
    }
}

