/*
 * Decompiled with CFR 0.152.
 */
package com.androidquery.callback;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.util.Xml;
import android.view.View;
import com.androidquery.auth.AccountHandle;
import com.androidquery.auth.GoogleHandle;
import com.androidquery.callback.AjaxStatus;
import com.androidquery.callback.BitmapAjaxCallback;
import com.androidquery.callback.ProxyHandle;
import com.androidquery.callback.Transformer;
import com.androidquery.util.AQUtility;
import com.androidquery.util.Common;
import com.androidquery.util.PredefinedBAOS;
import com.androidquery.util.Progress;
import com.androidquery.util.XmlDom;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.xmlpull.v1.XmlPullParser;

public abstract class AbstractAjaxCallback<T, K>
implements Runnable {
    private static int NET_TIMEOUT = 30000;
    private static String AGENT = null;
    private static int NETWORK_POOL = 4;
    private static boolean GZIP = true;
    private static boolean REUSE_CLIENT = true;
    private static boolean SIMULATE_ERROR = false;
    private Class<T> type;
    private Reference<Object> whandler;
    private Object handler;
    private String callback;
    private WeakReference<Object> progress;
    private String url;
    private String networkUrl;
    protected Map<String, Object> params;
    protected Map<String, String> headers;
    protected Map<String, String> cookies;
    private Transformer transformer;
    protected T result;
    private int policy = 0;
    private File cacheDir;
    private File targetFile;
    protected AccountHandle ah;
    protected AjaxStatus status;
    protected boolean fileCache;
    protected boolean memCache;
    private boolean refresh;
    private int timeout = 0;
    private boolean redirect = true;
    private long expire;
    private String encoding = "UTF-8";
    private WeakReference<Activity> act;
    private int method = 4;
    private HttpUriRequest request;
    private boolean uiCallback = true;
    private int retry = 0;
    private static Transformer st;
    private HttpHost proxy;
    private static final Class<?>[] DEFAULT_SIG;
    private boolean completed;
    private boolean blocked;
    private boolean reauth;
    private static ExecutorService fetchExe;
    private static SocketFactory ssf;
    private static DefaultHttpClient client;
    private static ProxyHandle proxyHandle;
    private static int lastStatus;
    private boolean abort;
    private static final String lineEnd = "\r\n";
    private static final String twoHyphens = "--";
    private static final String boundary = "*****";

    static {
        DEFAULT_SIG = new Class[]{String.class, Object.class, AjaxStatus.class};
        lastStatus = 200;
    }

    private K self() {
        return (K)this;
    }

    private void clear() {
        this.whandler = null;
        this.handler = null;
        this.progress = null;
        this.request = null;
        this.transformer = null;
        this.ah = null;
        this.act = null;
    }

    public static void setTimeout(int timeout) {
        NET_TIMEOUT = timeout;
    }

    public static void setAgent(String agent) {
        AGENT = agent;
    }

    public static void setGZip(boolean gzip) {
        GZIP = gzip;
    }

    public static void setSimulateError(boolean error) {
        SIMULATE_ERROR = error;
    }

    public static void setTransformer(Transformer transformer) {
        st = transformer;
    }

    public Class<T> getType() {
        return this.type;
    }

    public K weakHandler(Object handler, String callback) {
        this.whandler = new WeakReference<Object>(handler);
        this.callback = callback;
        this.handler = null;
        return this.self();
    }

    public K handler(Object handler, String callback) {
        this.handler = handler;
        this.callback = callback;
        this.whandler = null;
        return this.self();
    }

    public K url(String url) {
        this.url = url;
        return this.self();
    }

    public K networkUrl(String url) {
        this.networkUrl = url;
        return this.self();
    }

    public K type(Class<T> type) {
        this.type = type;
        return this.self();
    }

    public K method(int method) {
        this.method = method;
        return this.self();
    }

    public K timeout(int timeout) {
        this.timeout = timeout;
        return this.self();
    }

    public K redirect(boolean redirect) {
        this.redirect = redirect;
        return this.self();
    }

    public K retry(int retry) {
        this.retry = retry;
        return this.self();
    }

    public K transformer(Transformer transformer) {
        this.transformer = transformer;
        return this.self();
    }

    public K fileCache(boolean cache) {
        this.fileCache = cache;
        return this.self();
    }

    public K memCache(boolean cache) {
        this.memCache = cache;
        return this.self();
    }

    public K policy(int policy) {
        this.policy = policy;
        return this.self();
    }

    public K refresh(boolean refresh) {
        this.refresh = refresh;
        return this.self();
    }

    public K uiCallback(boolean uiCallback) {
        this.uiCallback = uiCallback;
        return this.self();
    }

    public K expire(long expire) {
        this.expire = expire;
        return this.self();
    }

    public K header(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
        return this.self();
    }

    public K headers(Map<String, String> headers) {
        this.headers = headers;
        return this.self();
    }

    public K cookie(String name, String value) {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, String>();
        }
        this.cookies.put(name, value);
        return this.self();
    }

    public K cookies(Map<String, String> cookies) {
        this.cookies = cookies;
        return this.self();
    }

    public K encoding(String encoding) {
        this.encoding = encoding;
        return this.self();
    }

    public K proxy(String host, int port) {
        this.proxy = new HttpHost(host, port);
        return this.self();
    }

    public K proxy(String host, int port, String user, String password) {
        this.proxy(host, port);
        String authHeader = AbstractAjaxCallback.makeAuthHeader(user, password);
        AQUtility.debug("proxy auth", authHeader);
        return this.header("Proxy-Authorization", authHeader);
    }

    private static String makeAuthHeader(String username, String password) {
        String cred = String.valueOf(username) + ":" + password;
        byte[] data = cred.getBytes();
        String auth = "Basic " + new String(AQUtility.encode64(data, 0, data.length));
        return auth;
    }

    public K targetFile(File file) {
        this.targetFile = file;
        return this.self();
    }

    public K param(String name, Object value) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(name, value);
        return this.self();
    }

    public K params(Map<String, ?> params) {
        this.params = params;
        return this.self();
    }

    public K progress(View view) {
        return this.progress((Object)view);
    }

    public K progress(Dialog dialog) {
        return this.progress((Object)dialog);
    }

    public K progress(Object progress) {
        if (progress != null) {
            this.progress = new WeakReference<Object>(progress);
        }
        return this.self();
    }

    void callback() {
        this.showProgress(false);
        this.completed = true;
        if (this.isActive()) {
            if (this.callback != null) {
                Object handler = this.getHandler();
                Class[] AJAX_SIG = new Class[]{String.class, this.type, AjaxStatus.class};
                AQUtility.invokeHandler(handler, this.callback, true, true, AJAX_SIG, DEFAULT_SIG, new Object[]{this.url, this.result, this.status});
            } else {
                try {
                    this.callback(this.url, this.result, this.status);
                }
                catch (Exception e) {
                    AQUtility.report(e);
                }
            }
        } else {
            this.skip(this.url, this.result, this.status);
        }
        this.filePut();
        if (!this.blocked) {
            this.status.close();
        }
        this.wake();
        AQUtility.debugNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wake() {
        if (!this.blocked) {
            return;
        }
        AbstractAjaxCallback abstractAjaxCallback = this;
        synchronized (abstractAjaxCallback) {
            try {
                this.notifyAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block() {
        if (AQUtility.isUIThread()) {
            throw new IllegalStateException("Cannot block UI thread.");
        }
        if (this.completed) {
            return;
        }
        try {
            AbstractAjaxCallback abstractAjaxCallback = this;
            synchronized (abstractAjaxCallback) {
                this.blocked = true;
                this.wait(NET_TIMEOUT + 5000);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void callback(String url, T object, AjaxStatus status) {
    }

    protected void skip(String url, T object, AjaxStatus status) {
    }

    protected T fileGet(String url, File file, AjaxStatus status) {
        try {
            byte[] data = null;
            if (this.isStreamingContent()) {
                status.file(file);
            } else {
                data = AQUtility.toBytes(new FileInputStream(file));
            }
            return this.transform(url, data, status);
        }
        catch (Exception e) {
            AQUtility.debug(e);
            return null;
        }
    }

    protected T datastoreGet(String url) {
        return null;
    }

    protected void showProgress(final boolean show) {
        Object p;
        Object v0 = p = this.progress == null ? null : this.progress.get();
        if (p != null) {
            if (AQUtility.isUIThread()) {
                Common.showProgress(p, this.url, show);
            } else {
                AQUtility.post(new Runnable(){

                    @Override
                    public void run() {
                        Common.showProgress(p, AbstractAjaxCallback.this.url, show);
                    }
                });
            }
        }
    }

    protected T transform(String url, byte[] data, AjaxStatus status) {
        if (this.type == null) {
            return null;
        }
        File file = status.getFile();
        if (data != null) {
            if (this.type.equals(Bitmap.class)) {
                return (T)BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
            }
            if (this.type.equals(JSONObject.class)) {
                JSONObject result = null;
                String str = null;
                try {
                    str = new String(data, this.encoding);
                    result = (JSONObject)new JSONTokener(str).nextValue();
                }
                catch (Exception e) {
                    AQUtility.debug(e);
                    AQUtility.debug(str);
                }
                return (T)result;
            }
            if (this.type.equals(JSONArray.class)) {
                JSONArray result = null;
                try {
                    String str = new String(data, this.encoding);
                    result = (JSONArray)new JSONTokener(str).nextValue();
                }
                catch (Exception e) {
                    AQUtility.debug(e);
                }
                return (T)result;
            }
            if (this.type.equals(String.class)) {
                String result = null;
                if (status.getSource() == 1) {
                    AQUtility.debug("network");
                    result = this.correctEncoding(data, this.encoding, status);
                } else {
                    AQUtility.debug("file");
                    try {
                        result = new String(data, this.encoding);
                    }
                    catch (Exception e) {
                        AQUtility.debug(e);
                    }
                }
                return (T)result;
            }
            if (this.type.equals(byte[].class)) {
                return (T)data;
            }
            if (this.transformer != null) {
                return this.transformer.transform(url, this.type, this.encoding, data, status);
            }
            if (st != null) {
                return st.transform(url, this.type, this.encoding, data, status);
            }
        } else if (file != null) {
            if (this.type.equals(File.class)) {
                return (T)file;
            }
            if (this.type.equals(XmlDom.class)) {
                XmlDom result = null;
                try {
                    FileInputStream fis = new FileInputStream(file);
                    result = new XmlDom(fis);
                    status.closeLater(fis);
                }
                catch (Exception e) {
                    AQUtility.report(e);
                    return null;
                }
                return (T)result;
            }
            if (this.type.equals(XmlPullParser.class)) {
                XmlPullParser parser = Xml.newPullParser();
                try {
                    FileInputStream fis = new FileInputStream(file);
                    parser.setInput((InputStream)fis, this.encoding);
                    status.closeLater(fis);
                }
                catch (Exception e) {
                    AQUtility.report(e);
                    return null;
                }
                return (T)parser;
            }
            if (this.type.equals(InputStream.class)) {
                try {
                    FileInputStream fis = new FileInputStream(file);
                    status.closeLater(fis);
                    return (T)fis;
                }
                catch (Exception e) {
                    AQUtility.report(e);
                    return null;
                }
            }
        }
        return null;
    }

    private String getCharset(String html) {
        String pattern = "<meta [^>]*http-equiv[^>]*\"Content-Type\"[^>]*>";
        Pattern p = Pattern.compile(pattern, 2);
        Matcher m = p.matcher(html);
        if (!m.find()) {
            return null;
        }
        String tag = m.group();
        return this.parseCharset(tag);
    }

    private String parseCharset(String tag) {
        if (tag == null) {
            return null;
        }
        int i = tag.indexOf("charset");
        if (i == -1) {
            return null;
        }
        int e = tag.indexOf(";", i);
        if (e == -1) {
            e = tag.length();
        }
        String charset = tag.substring(i + 7, e).replaceAll("[^\\w-]", "");
        return charset;
    }

    private String correctEncoding(byte[] data, String target, AjaxStatus status) {
        String result = null;
        try {
            if (!"utf-8".equalsIgnoreCase(target)) {
                return new String(data, target);
            }
            String header = this.parseCharset(status.getHeader("Content-Type"));
            AQUtility.debug("parsing header", header);
            if (header != null) {
                return new String(data, header);
            }
            result = new String(data, "utf-8");
            String charset = this.getCharset(result);
            AQUtility.debug("parsing needed", charset);
            if (charset != null && !"utf-8".equalsIgnoreCase(charset)) {
                AQUtility.debug("correction needed", charset);
                result = new String(data, charset);
                status.data(result.getBytes("utf-8"));
            }
        }
        catch (Exception e) {
            AQUtility.report(e);
        }
        return result;
    }

    protected T memGet(String url) {
        return null;
    }

    protected void memPut(String url, T object) {
    }

    protected void filePut(String url, T object, File file, byte[] data) {
        if (file == null || data == null) {
            return;
        }
        AQUtility.storeAsync(file, data, 0L);
    }

    protected File accessFile(File cacheDir, String url) {
        long diff;
        if (this.expire < 0L) {
            return null;
        }
        File file = AQUtility.getExistedCacheByUrl(cacheDir, url);
        if (file != null && this.expire != 0L && (diff = System.currentTimeMillis() - file.lastModified()) > this.expire) {
            return null;
        }
        return file;
    }

    public void async(Activity act) {
        if (act.isFinishing()) {
            AQUtility.warn("Warning", "Possible memory leak. Calling ajax with a terminated activity.");
        }
        if (this.type == null) {
            AQUtility.warn("Warning", "type() is not called with response type.");
            return;
        }
        this.act = new WeakReference<Activity>(act);
        this.async((Context)act);
    }

    public void async(Context context) {
        if (this.status == null) {
            this.status = new AjaxStatus();
            this.status.redirect(this.url).refresh(this.refresh);
        } else if (this.status.getDone()) {
            this.status.reset();
            this.result = null;
        }
        this.showProgress(true);
        if (this.ah != null && !this.ah.authenticated()) {
            AQUtility.debug("auth needed", this.url);
            this.ah.auth(this);
            return;
        }
        this.work(context);
    }

    private boolean isActive() {
        if (this.act == null) {
            return true;
        }
        Activity a = (Activity)this.act.get();
        return a != null && !a.isFinishing();
    }

    public void failure(int code, String message) {
        if (this.status != null) {
            this.status.code(code).message(message).done();
            if (this.uiCallback) {
                AQUtility.post(this);
            } else {
                this.afterWork();
            }
        }
    }

    private void work(Context context) {
        T object = this.memGet(this.url);
        if (object != null) {
            this.result = object;
            this.status.source(4).done();
            this.callback();
        } else {
            this.cacheDir = AQUtility.getCacheDir(context, this.policy);
            AbstractAjaxCallback.execute(this);
        }
    }

    protected boolean cacheAvailable(Context context) {
        return this.fileCache && AQUtility.getExistedCacheByUrl(AQUtility.getCacheDir(context, this.policy), this.url) != null;
    }

    @Override
    public void run() {
        if (!this.status.getDone()) {
            try {
                this.backgroundWork();
            }
            catch (Throwable e) {
                AQUtility.debug(e);
                this.status.code(-101).done();
            }
            if (!this.status.getReauth()) {
                if (this.uiCallback) {
                    AQUtility.post(this);
                } else {
                    this.afterWork();
                }
            }
        } else {
            this.afterWork();
        }
    }

    private void backgroundWork() {
        if (!this.refresh && this.fileCache) {
            this.fileWork();
        }
        if (this.result == null) {
            this.datastoreWork();
        }
        if (this.result == null) {
            this.networkWork();
        }
    }

    private String getCacheUrl() {
        if (this.ah != null) {
            return this.ah.getCacheUrl(this.url);
        }
        return this.url;
    }

    private String getNetworkUrl(String url) {
        String result = url;
        if (this.networkUrl != null) {
            result = this.networkUrl;
        }
        if (this.ah != null) {
            result = this.ah.getNetworkUrl(result);
        }
        return result;
    }

    private void fileWork() {
        File file = this.accessFile(this.cacheDir, this.getCacheUrl());
        if (file != null) {
            this.status.source(3);
            this.result = this.fileGet(this.url, file, this.status);
            if (this.result != null) {
                this.status.time(new Date(file.lastModified())).done();
            }
        }
    }

    private void datastoreWork() {
        this.result = this.datastoreGet(this.url);
        if (this.result != null) {
            this.status.source(2).done();
        }
    }

    private void networkWork() {
        if (this.url == null) {
            this.status.code(-101).done();
            return;
        }
        byte[] data = null;
        try {
            this.network(this.retry + 1);
            if (this.ah != null && this.ah.expired(this, this.status) && !this.reauth) {
                AQUtility.debug("reauth needed", this.status.getMessage());
                this.reauth = true;
                if (this.ah.reauth(this)) {
                    this.network();
                } else {
                    this.status.reauth(true);
                    return;
                }
            }
            data = this.status.getData();
        }
        catch (IOException e) {
            AQUtility.debug("IOException");
            String message = e.getMessage();
            if (message != null && message.contains("No authentication challenges found")) {
                this.status.code(401).message(message);
            } else {
                this.status.code(-101).message("network error");
            }
        }
        catch (Exception e) {
            AQUtility.debug(e);
            this.status.code(-101).message("network error");
        }
        try {
            this.result = this.transform(this.url, data, this.status);
        }
        catch (Exception e) {
            AQUtility.debug(e);
        }
        if (this.result == null && data != null) {
            this.status.code(-103).message("transform error");
        }
        lastStatus = this.status.getCode();
        this.status.done();
    }

    protected File getCacheFile() {
        return AQUtility.getCacheFile(this.cacheDir, this.getCacheUrl());
    }

    protected boolean isStreamingContent() {
        return File.class.equals(this.type) || XmlPullParser.class.equals(this.type) || InputStream.class.equals(this.type) || XmlDom.class.equals(this.type);
    }

    private File getPreFile() {
        boolean pre = this.isStreamingContent();
        File result = null;
        if (pre) {
            if (this.targetFile != null) {
                result = this.targetFile;
            } else if (this.fileCache) {
                result = this.getCacheFile();
            } else {
                File dir = AQUtility.getTempDir();
                if (dir == null) {
                    dir = this.cacheDir;
                }
                result = AQUtility.getCacheFile(dir, this.url);
            }
        }
        if (result != null && !result.exists()) {
            try {
                result.getParentFile().mkdirs();
                result.createNewFile();
            }
            catch (Exception e) {
                AQUtility.report(e);
                return null;
            }
        }
        return result;
    }

    private void filePut() {
        File file;
        if (this.result != null && this.fileCache) {
            byte[] data = this.status.getData();
            try {
                if (data != null && this.status.getSource() == 1) {
                    File file2 = this.getCacheFile();
                    if (!this.status.getInvalid()) {
                        this.filePut(this.url, this.result, file2, data);
                    } else if (file2.exists()) {
                        file2.delete();
                    }
                }
            }
            catch (Exception e) {
                AQUtility.debug(e);
            }
            this.status.data(null);
        } else if (this.status.getCode() == -103 && (file = this.getCacheFile()).exists()) {
            file.delete();
            AQUtility.debug("invalidated cache due to transform error");
        }
    }

    private static String extractUrl(Uri uri) {
        String result = String.valueOf(uri.getScheme()) + "://" + uri.getAuthority() + uri.getPath();
        String fragment = uri.getFragment();
        if (fragment != null) {
            result = String.valueOf(result) + "#" + fragment;
        }
        return result;
    }

    private static Map<String, Object> extractParams(Uri uri) {
        String[] pairs;
        HashMap<String, Object> params = new HashMap<String, Object>();
        String[] stringArray = pairs = uri.getQuery().split("&");
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            String[] split = pair.split("=");
            if (split.length >= 2) {
                params.put(split[0], split[1]);
            } else if (split.length == 1) {
                params.put(split[0], "");
            }
            ++n2;
        }
        return params;
    }

    private void network(int attempts) throws IOException {
        if (attempts <= 1) {
            this.network();
            return;
        }
        int i = 0;
        while (i < attempts) {
            try {
                this.network();
                return;
            }
            catch (IOException e) {
                if (i == attempts - 1) {
                    throw e;
                }
                ++i;
            }
        }
    }

    private void network() throws IOException {
        String url = this.url;
        Map<String, Object> params = this.params;
        if (params == null && url.length() > 2000) {
            Uri uri = Uri.parse((String)url);
            url = AbstractAjaxCallback.extractUrl(uri);
            params = AbstractAjaxCallback.extractParams(uri);
        }
        url = this.getNetworkUrl(url);
        if (2 == this.method) {
            this.httpDelete(url, this.status);
        } else if (3 == this.method) {
            this.httpPut(url, params, this.status);
        } else {
            if (1 == this.method && params == null) {
                params = new HashMap<String, Object>();
            }
            if (params == null) {
                this.httpGet(url, this.status);
            } else if (AbstractAjaxCallback.isMultiPart(params)) {
                this.httpMulti(url, params, this.status);
            } else {
                this.httpPost(url, params, this.status);
            }
        }
    }

    private void afterWork() {
        if (this.url != null && this.memCache) {
            this.memPut(this.url, this.result);
        }
        this.callback();
        this.clear();
    }

    public static void execute(Runnable job) {
        if (fetchExe == null) {
            fetchExe = Executors.newFixedThreadPool(NETWORK_POOL);
        }
        fetchExe.execute(job);
    }

    public static int getActiveCount() {
        int result = 0;
        if (fetchExe instanceof ThreadPoolExecutor) {
            result = ((ThreadPoolExecutor)fetchExe).getActiveCount();
        }
        return result;
    }

    public static void setNetworkLimit(int limit) {
        NETWORK_POOL = Math.max(1, Math.min(25, limit));
        fetchExe = null;
        AQUtility.debug("setting network limit", NETWORK_POOL);
    }

    public static void cancel() {
        if (fetchExe != null) {
            fetchExe.shutdownNow();
            fetchExe = null;
        }
        BitmapAjaxCallback.clearTasks();
    }

    private static String patchUrl(String url) {
        url = url.replaceAll(" ", "%20").replaceAll("\\|", "%7C");
        return url;
    }

    private void httpGet(String url, AjaxStatus status) throws IOException {
        AQUtility.debug("get", url);
        url = AbstractAjaxCallback.patchUrl(url);
        HttpGet get = new HttpGet(url);
        this.httpDo((HttpUriRequest)get, url, status);
    }

    private void httpDelete(String url, AjaxStatus status) throws IOException {
        AQUtility.debug("get", url);
        url = AbstractAjaxCallback.patchUrl(url);
        HttpDelete del = new HttpDelete(url);
        this.httpDo((HttpUriRequest)del, url, status);
    }

    private void httpPost(String url, Map<String, Object> params, AjaxStatus status) throws ClientProtocolException, IOException {
        AQUtility.debug("post", url);
        HttpPost req = new HttpPost(url);
        this.httpEntity(url, (HttpEntityEnclosingRequestBase)req, params, status);
    }

    private void httpPut(String url, Map<String, Object> params, AjaxStatus status) throws ClientProtocolException, IOException {
        AQUtility.debug("put", url);
        HttpPut req = new HttpPut(url);
        this.httpEntity(url, (HttpEntityEnclosingRequestBase)req, params, status);
    }

    private void httpEntity(String url, HttpEntityEnclosingRequestBase req, Map<String, Object> params, AjaxStatus status) throws ClientProtocolException, IOException {
        req.getParams().setBooleanParameter("http.protocol.expect-continue", false);
        HttpEntity entity = null;
        Object value = params.get("%entity");
        if (value instanceof HttpEntity) {
            entity = (HttpEntity)value;
        } else {
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, Object> e : params.entrySet()) {
                value = e.getValue();
                if (value == null) continue;
                pairs.add(new BasicNameValuePair(e.getKey(), value.toString()));
            }
            entity = new UrlEncodedFormEntity(pairs, "UTF-8");
        }
        if (this.headers != null && !this.headers.containsKey("Content-Type")) {
            this.headers.put("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        }
        req.setEntity(entity);
        this.httpDo((HttpUriRequest)req, url, status);
    }

    public static void setSSF(SocketFactory sf) {
        ssf = sf;
        client = null;
    }

    public static void setReuseHttpClient(boolean reuse) {
        REUSE_CLIENT = reuse;
        client = null;
    }

    private static DefaultHttpClient getClient() {
        if (client == null || !REUSE_CLIENT) {
            AQUtility.debug("creating http client");
            BasicHttpParams httpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)NET_TIMEOUT);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)NET_TIMEOUT);
            ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)httpParams, (ConnPerRoute)new ConnPerRouteBean(25));
            HttpConnectionParams.setSocketBufferSize((HttpParams)httpParams, (int)8192);
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            registry.register(new Scheme("https", (SocketFactory)(ssf == null ? SSLSocketFactory.getSocketFactory() : ssf), 443));
            ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager((HttpParams)httpParams, registry);
            client = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)httpParams);
        }
        return client;
    }

    private HttpResponse execute(HttpUriRequest hr, DefaultHttpClient client, HttpContext context) throws ClientProtocolException, IOException {
        HttpResponse response = null;
        if (hr.getURI().getAuthority().contains("_")) {
            URL urlObj = hr.getURI().toURL();
            HttpHost host = urlObj.getPort() == -1 ? new HttpHost(urlObj.getHost(), 80, urlObj.getProtocol()) : new HttpHost(urlObj.getHost(), urlObj.getPort(), urlObj.getProtocol());
            response = client.execute(host, (HttpRequest)hr, context);
        } else {
            response = client.execute(hr, context);
        }
        return response;
    }

    public static void setProxyHandle(ProxyHandle handle) {
        proxyHandle = handle;
    }

    private void httpDo(HttpUriRequest hr, String url, AjaxStatus status) throws ClientProtocolException, IOException {
        File file;
        String error;
        String message;
        int code;
        String redirect;
        byte[] data;
        HttpResponse response;
        BasicHttpContext context;
        DefaultHttpClient client;
        block34: {
            String cookie;
            client = AbstractAjaxCallback.getClient();
            if (proxyHandle != null) {
                proxyHandle.applyProxy(this, (HttpRequest)hr, client);
            }
            if (AGENT != null) {
                hr.addHeader("User-Agent", AGENT);
            } else if (AGENT == null && GZIP) {
                hr.addHeader("User-Agent", "gzip");
            }
            if (this.headers != null) {
                for (String name : this.headers.keySet()) {
                    hr.addHeader(name, this.headers.get(name));
                }
            }
            if (GZIP && (this.headers == null || !this.headers.containsKey("Accept-Encoding"))) {
                hr.addHeader("Accept-Encoding", "gzip");
            }
            if (this.ah != null) {
                this.ah.applyToken(this, (HttpRequest)hr);
            }
            if ((cookie = this.makeCookie()) != null) {
                hr.addHeader("Cookie", cookie);
            }
            HttpParams hp = hr.getParams();
            if (this.proxy != null) {
                hp.setParameter("http.route.default-proxy", (Object)this.proxy);
            }
            if (this.timeout > 0) {
                hp.setParameter("http.connection.timeout", (Object)this.timeout);
                hp.setParameter("http.socket.timeout", (Object)this.timeout);
            }
            if (!this.redirect) {
                hp.setBooleanParameter("http.protocol.handle-redirects", false);
            }
            context = new BasicHttpContext();
            BasicCookieStore cookieStore = new BasicCookieStore();
            context.setAttribute("http.cookie-store", (Object)cookieStore);
            this.request = hr;
            if (this.abort) {
                throw new IOException("Aborted");
            }
            if (SIMULATE_ERROR) {
                throw new IOException("Simulated Error");
            }
            response = null;
            try {
                response = this.execute(hr, client, (HttpContext)context);
            }
            catch (HttpHostConnectException e) {
                if (this.proxy != null) {
                    AQUtility.debug("proxy failed, retrying without proxy");
                    hp.setParameter("http.route.default-proxy", null);
                    response = this.execute(hr, client, (HttpContext)context);
                }
                throw e;
            }
            data = null;
            redirect = url;
            code = response.getStatusLine().getStatusCode();
            message = response.getStatusLine().getReasonPhrase();
            error = null;
            HttpEntity entity = response.getEntity();
            file = null;
            File tempFile = null;
            if (code < 200 || code >= 300) {
                InputStream is = null;
                try {
                    try {
                        if (entity != null) {
                            is = entity.getContent();
                            byte[] s = this.toData(this.getEncoding(entity), is);
                            error = new String(s, "UTF-8");
                            AQUtility.debug("error", error);
                        }
                    }
                    catch (Exception e) {
                        AQUtility.debug(e);
                        AQUtility.close(is);
                        break block34;
                    }
                }
                catch (Throwable throwable) {
                    AQUtility.close(is);
                    throw throwable;
                }
                AQUtility.close(is);
            } else {
                HttpHost currentHost = (HttpHost)context.getAttribute("http.target_host");
                HttpUriRequest currentReq = (HttpUriRequest)context.getAttribute("http.request");
                redirect = String.valueOf(currentHost.toURI()) + currentReq.getURI();
                int size = Math.max(32, Math.min(65536, (int)entity.getContentLength()));
                OutputStream os = null;
                InputStream is = null;
                try {
                    file = this.getPreFile();
                    if (file == null) {
                        os = new PredefinedBAOS(size);
                    } else {
                        tempFile = this.makeTempFile(file);
                        os = new BufferedOutputStream(new FileOutputStream(tempFile));
                    }
                    is = entity.getContent();
                    boolean gzip = "gzip".equalsIgnoreCase(this.getEncoding(entity));
                    if (gzip) {
                        is = new GZIPInputStream(is);
                    }
                    int contentLength = (int)entity.getContentLength();
                    this.copy(is, os, contentLength, tempFile, file);
                    if (file == null) {
                        data = ((PredefinedBAOS)os).toByteArray();
                    } else if (!file.exists() || file.length() == 0L) {
                        file = null;
                    }
                }
                catch (Throwable throwable) {
                    AQUtility.close(is);
                    AQUtility.close(os);
                    throw throwable;
                }
                AQUtility.close(is);
                AQUtility.close(os);
            }
        }
        AQUtility.debug("response", code);
        if (data != null) {
            AQUtility.debug(data.length, url);
        }
        status.code(code).message(message).error(error).redirect(redirect).time(new Date()).data(data).file(file).client(client).context((HttpContext)context).headers(response.getAllHeaders());
    }

    private String getEncoding(HttpEntity entity) {
        if (entity == null) {
            return null;
        }
        Header eheader = entity.getContentEncoding();
        if (eheader == null) {
            return null;
        }
        return eheader.getValue();
    }

    private void copy(InputStream is, OutputStream os, int max, File tempFile, File destFile) throws IOException {
        if (destFile == null) {
            this.copy(is, os, max);
            return;
        }
        try {
            this.copy(is, os, max);
            is.close();
            os.close();
            tempFile.renameTo(destFile);
        }
        catch (IOException e) {
            AQUtility.debug("copy failed, deleting files");
            tempFile.delete();
            destFile.delete();
            AQUtility.close(is);
            AQUtility.close(os);
            throw e;
        }
    }

    private File makeTempFile(File file) throws IOException {
        File temp = new File(String.valueOf(file.getAbsolutePath()) + ".tmp");
        temp.createNewFile();
        return temp;
    }

    private void copy(InputStream is, OutputStream os, int max) throws IOException {
        Object o = null;
        if (this.progress != null) {
            o = this.progress.get();
        }
        Progress p = null;
        if (o != null) {
            p = new Progress(o);
        }
        AQUtility.copy(is, os, max, p);
    }

    public K auth(Activity act, String type, String account) {
        if (Build.VERSION.SDK_INT >= 5 && type.startsWith("g.")) {
            this.ah = new GoogleHandle(act, type, account);
        }
        return this.self();
    }

    public K auth(AccountHandle handle) {
        this.ah = handle;
        return this.self();
    }

    public String getUrl() {
        return this.url;
    }

    public Object getHandler() {
        if (this.handler != null) {
            return this.handler;
        }
        if (this.whandler == null) {
            return null;
        }
        return this.whandler.get();
    }

    public String getCallback() {
        return this.callback;
    }

    protected static int getLastStatus() {
        return lastStatus;
    }

    public T getResult() {
        return this.result;
    }

    public AjaxStatus getStatus() {
        return this.status;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void abort() {
        this.abort = true;
        if (this.request != null && !this.request.isAborted()) {
            this.request.abort();
        }
    }

    private static boolean isMultiPart(Map<String, Object> params) {
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object value = entry.getValue();
            AQUtility.debug(entry.getKey(), value);
            if (!(value instanceof File) && !(value instanceof byte[]) && !(value instanceof InputStream)) continue;
            return true;
        }
        return false;
    }

    private void httpMulti(String url, Map<String, Object> params, AjaxStatus status) throws IOException {
        String cookie;
        AQUtility.debug("multipart", url);
        HttpURLConnection conn = null;
        DataOutputStream dos = null;
        URL u = new URL(url);
        Proxy py = null;
        if (this.proxy != null) {
            AQUtility.debug("proxy", this.proxy);
            py = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxy.getHostName(), this.proxy.getPort()));
        } else if (proxyHandle != null) {
            py = proxyHandle.makeProxy(this);
        }
        conn = py == null ? (HttpURLConnection)u.openConnection() : (HttpURLConnection)u.openConnection(py);
        conn.setInstanceFollowRedirects(false);
        conn.setConnectTimeout(NET_TIMEOUT * 4);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty("Content-Type", "multipart/form-data;charset=utf-8;boundary=*****");
        if (this.headers != null) {
            for (String name : this.headers.keySet()) {
                conn.setRequestProperty(name, this.headers.get(name));
            }
        }
        if ((cookie = this.makeCookie()) != null) {
            conn.setRequestProperty("Cookie", cookie);
        }
        if (this.ah != null) {
            this.ah.applyToken(this, conn);
        }
        dos = new DataOutputStream(conn.getOutputStream());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            AbstractAjaxCallback.writeObject(dos, entry.getKey(), entry.getValue());
        }
        dos.writeBytes("--*****--\r\n");
        dos.flush();
        dos.close();
        conn.connect();
        int code = conn.getResponseCode();
        String message = conn.getResponseMessage();
        byte[] data = null;
        String encoding = conn.getContentEncoding();
        String error = null;
        if (code < 200 || code >= 300) {
            error = new String(this.toData(encoding, conn.getErrorStream()), "UTF-8");
            AQUtility.debug("error", error);
        } else {
            data = this.toData(encoding, conn.getInputStream());
        }
        AQUtility.debug("response", code);
        if (data != null) {
            AQUtility.debug(data.length, url);
        }
        status.code(code).message(message).redirect(url).time(new Date()).data(data).error(error).client(null);
    }

    private byte[] toData(String encoding, InputStream is) throws IOException {
        boolean gzip = "gzip".equalsIgnoreCase(encoding);
        if (gzip) {
            is = new GZIPInputStream(is);
        }
        return AQUtility.toBytes(is);
    }

    private static void writeObject(DataOutputStream dos, String name, Object obj) throws IOException {
        if (obj == null) {
            return;
        }
        if (obj instanceof File) {
            File file = (File)obj;
            AbstractAjaxCallback.writeData(dos, name, file.getName(), new FileInputStream(file));
        } else if (obj instanceof byte[]) {
            AbstractAjaxCallback.writeData(dos, name, name, new ByteArrayInputStream((byte[])obj));
        } else if (obj instanceof InputStream) {
            AbstractAjaxCallback.writeData(dos, name, name, (InputStream)obj);
        } else {
            AbstractAjaxCallback.writeField(dos, name, obj.toString());
        }
    }

    private static void writeData(DataOutputStream dos, String name, String filename, InputStream is) throws IOException {
        dos.writeBytes("--*****\r\n");
        dos.writeBytes("Content-Disposition: form-data; name=\"" + name + "\";" + " filename=\"" + filename + "\"" + lineEnd);
        dos.writeBytes("Content-Type: application/octet-stream");
        dos.writeBytes(lineEnd);
        dos.writeBytes("Content-Transfer-Encoding: binary");
        dos.writeBytes(lineEnd);
        dos.writeBytes(lineEnd);
        AQUtility.copy(is, dos);
        dos.writeBytes(lineEnd);
    }

    private static void writeField(DataOutputStream dos, String name, String value) throws IOException {
        dos.writeBytes("--*****\r\n");
        dos.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"");
        dos.writeBytes(lineEnd);
        dos.writeBytes(lineEnd);
        byte[] data = value.getBytes("UTF-8");
        dos.write(data);
        dos.writeBytes(lineEnd);
    }

    private String makeCookie() {
        if (this.cookies == null || this.cookies.size() == 0) {
            return null;
        }
        Iterator<String> iter = this.cookies.keySet().iterator();
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            String key = iter.next();
            String value = this.cookies.get(key);
            sb.append(key);
            sb.append("=");
            sb.append(value);
            if (!iter.hasNext()) continue;
            sb.append("; ");
        }
        return sb.toString();
    }
}

