/*
 * Decompiled with CFR 0.152.
 */
package com.androidquery.service;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.text.Editable;
import android.text.Html;
import com.androidquery.AQuery;
import com.androidquery.callback.AjaxCallback;
import com.androidquery.callback.AjaxStatus;
import com.androidquery.util.AQUtility;
import java.util.Locale;
import org.json.JSONObject;
import org.xml.sax.XMLReader;

public class MarketService {
    private Activity act;
    private AQuery aq;
    private Handler handler;
    private String locale;
    private String rateUrl;
    private String updateUrl;
    private boolean force;
    private int progress;
    private long expire = 720000L;
    private String version;
    private boolean fetch;
    private boolean completed;
    private int level = 0;
    public static final int REVISION = 0;
    public static final int MINOR = 1;
    public static final int MAJOR = 2;
    private static ApplicationInfo ai;
    private static PackageInfo pi;
    private static final String SKIP_VERSION = "aqs.skip";
    private static final String BULLET = "\u2022";

    public MarketService(Activity act) {
        this.act = act;
        this.aq = new AQuery(act);
        this.handler = new Handler();
        this.locale = Locale.getDefault().toString();
        this.updateUrl = this.rateUrl = this.getMarketUrl();
    }

    public MarketService rateUrl(String url) {
        this.rateUrl = url;
        return this;
    }

    public MarketService level(int level) {
        this.level = level;
        return this;
    }

    public MarketService updateUrl(String url) {
        this.updateUrl = url;
        return this;
    }

    public MarketService locale(String locale) {
        this.locale = locale;
        return this;
    }

    public MarketService progress(int id) {
        this.progress = id;
        return this;
    }

    public MarketService force(boolean force) {
        this.force = force;
        return this;
    }

    public MarketService expire(long expire) {
        this.expire = expire;
        return this;
    }

    private ApplicationInfo getApplicationInfo() {
        if (ai == null) {
            ai = this.act.getApplicationInfo();
        }
        return ai;
    }

    private PackageInfo getPackageInfo() {
        if (pi == null) {
            try {
                pi = this.act.getPackageManager().getPackageInfo(this.getAppId(), 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return pi;
    }

    private String getHost() {
        return "https://androidquery.appspot.com";
    }

    private String getQueryUrl() {
        String appId = this.getAppId();
        String url = String.valueOf(this.getHost()) + "/api/market?app=" + appId + "&locale=" + this.locale + "&version=" + this.getVersion() + "&code=" + this.getVersionCode() + "&aq=" + "0.26.7";
        if (this.force) {
            url = String.valueOf(url) + "&force=true";
        }
        return url;
    }

    private String getAppId() {
        return this.getApplicationInfo().packageName;
    }

    private Drawable getAppIcon() {
        Drawable d = this.getApplicationInfo().loadIcon(this.act.getPackageManager());
        return d;
    }

    private String getVersion() {
        return this.getPackageInfo().versionName;
    }

    private int getVersionCode() {
        return this.getPackageInfo().versionCode;
    }

    public void checkVersion() {
        String url = this.getQueryUrl();
        AjaxCallback cb = new AjaxCallback();
        ((AjaxCallback)((AjaxCallback)((AjaxCallback)((AjaxCallback)cb.url(url)).type(JSONObject.class)).handler(this.handler, "marketCb")).fileCache(!this.force)).expire(this.expire);
        ((AQuery)this.aq.progress(this.progress)).ajax(cb);
    }

    private static boolean openUrl(Activity act, String url) {
        block3: {
            try {
                if (url != null) break block3;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        Uri uri = Uri.parse((String)url);
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        act.startActivity(intent);
        return true;
    }

    private String getMarketUrl() {
        String id = this.getAppId();
        return "market://details?id=" + id;
    }

    protected void callback(String url, JSONObject jo, AjaxStatus status) {
        if (jo == null) {
            return;
        }
        String latestVer = jo.optString("version", "0");
        int latestCode = jo.optInt("code", 0);
        AQUtility.debug("version", String.valueOf(this.getVersion()) + "->" + latestVer + ":" + this.getVersionCode() + "->" + latestCode);
        AQUtility.debug("outdated", this.outdated(latestVer, latestCode));
        if (this.force || this.outdated(latestVer, latestCode)) {
            this.showUpdateDialog(jo);
        }
    }

    private boolean outdated(String latestVer, int latestCode) {
        String skip = MarketService.getSkipVersion((Context)this.act);
        if (latestVer.equals(skip)) {
            return false;
        }
        String version = this.getVersion();
        int code = this.getVersionCode();
        if (!version.equals(latestVer) && code <= latestCode) {
            return this.requireUpdate(version, latestVer, this.level);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean requireUpdate(String existVer, String latestVer, int level) {
        if (existVer.equals(latestVer)) {
            return false;
        }
        try {
            String[] evs = existVer.split("\\.");
            String[] lvs = latestVer.split("\\.");
            if (evs.length < 3 || lvs.length < 3) {
                return true;
            }
            switch (level) {
                case 0: {
                    if (!evs[evs.length - 1].equals(lvs[lvs.length - 1])) {
                        return true;
                    }
                }
                case 1: {
                    if (!evs[evs.length - 2].equals(lvs[lvs.length - 2])) {
                        return true;
                    }
                }
                case 2: {
                    return !evs[evs.length - 3].equals(lvs[lvs.length - 3]);
                }
            }
            return true;
        }
        catch (Exception e) {
            AQUtility.report(e);
            return true;
        }
    }

    protected void showUpdateDialog(JSONObject jo) {
        if (jo == null || this.version != null) {
            return;
        }
        if (!this.isActive()) {
            return;
        }
        JSONObject dia = jo.optJSONObject("dialog");
        String update = dia.optString("update", "Update");
        String skip = dia.optString("skip", "Skip");
        String rate = dia.optString("rate", "Rate");
        String body = dia.optString("wbody", "");
        String title = dia.optString("title", "Update Available");
        AQUtility.debug("wbody", body);
        this.version = jo.optString("version", null);
        Drawable icon = this.getAppIcon();
        Activity context = this.act;
        AlertDialog dialog = new AlertDialog.Builder((Context)context).setIcon(icon).setTitle((CharSequence)title).setPositiveButton((CharSequence)rate, (DialogInterface.OnClickListener)this.handler).setNeutralButton((CharSequence)skip, (DialogInterface.OnClickListener)this.handler).setNegativeButton((CharSequence)update, (DialogInterface.OnClickListener)this.handler).create();
        dialog.setMessage((CharSequence)Html.fromHtml((String)MarketService.patchBody(body), null, (Html.TagHandler)this.handler));
        this.aq.show((Dialog)dialog);
    }

    private static String patchBody(String body) {
        return "<small>" + body + "</small>";
    }

    private static void setSkipVersion(Context context, String version) {
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putString(SKIP_VERSION, version).commit();
    }

    private static String getSkipVersion(Context context) {
        return PreferenceManager.getDefaultSharedPreferences((Context)context).getString(SKIP_VERSION, null);
    }

    private boolean isActive() {
        return !this.act.isFinishing();
    }

    private class Handler
    implements DialogInterface.OnClickListener,
    Html.TagHandler {
        private Handler() {
        }

        public void marketCb(String url, JSONObject jo, AjaxStatus status) {
            if (MarketService.this.act.isFinishing()) {
                return;
            }
            if (jo != null) {
                String s = jo.optString("status");
                if ("1".equals(s)) {
                    if (jo.has("dialog")) {
                        this.cb(url, jo, status);
                    }
                    if (!MarketService.this.fetch && jo.optBoolean("fetch", false) && status.getSource() == 1) {
                        MarketService.this.fetch = true;
                        String marketUrl = jo.optString("marketUrl", null);
                        AjaxCallback cb = new AjaxCallback();
                        ((AjaxCallback)((AjaxCallback)cb.url(marketUrl)).type(String.class)).handler(this, "detailCb");
                        ((AQuery)MarketService.this.aq.progress(MarketService.this.progress)).ajax(cb);
                    }
                } else if ("0".equals(s)) {
                    status.invalidate();
                } else {
                    this.cb(url, jo, status);
                }
            } else {
                this.cb(url, jo, status);
            }
        }

        private void cb(String url, JSONObject jo, AjaxStatus status) {
            if (!MarketService.this.completed) {
                MarketService.this.completed = true;
                MarketService.this.progress = 0;
                MarketService.this.callback(url, jo, status);
            }
        }

        public void detailCb(String url, String html, AjaxStatus status) {
            if (html != null && html.length() > 1000) {
                String qurl = MarketService.this.getQueryUrl();
                AjaxCallback cb = new AjaxCallback();
                ((AjaxCallback)((AjaxCallback)cb.url(qurl)).type(JSONObject.class)).handler(this, "marketCb");
                cb.param("html", html);
                ((AQuery)MarketService.this.aq.progress(MarketService.this.progress)).ajax(cb);
            }
        }

        public void onClick(DialogInterface dialog, int which) {
            switch (which) {
                case -1: {
                    MarketService.openUrl(MarketService.this.act, MarketService.this.rateUrl);
                    break;
                }
                case -2: {
                    MarketService.openUrl(MarketService.this.act, MarketService.this.updateUrl);
                    break;
                }
                case -3: {
                    MarketService.setSkipVersion((Context)MarketService.this.act, MarketService.this.version);
                }
            }
        }

        public void handleTag(boolean opening, String tag, Editable output, XMLReader xmlReader) {
            if ("li".equals(tag)) {
                if (opening) {
                    output.append((CharSequence)"  ");
                    output.append((CharSequence)MarketService.BULLET);
                    output.append((CharSequence)"  ");
                } else {
                    output.append((CharSequence)"\n");
                }
            }
        }
    }
}

