/*
 * Decompiled with CFR 0.152.
 */
package com.androidquery.util;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.view.ViewGroup;
import android.widget.ImageView;
import java.lang.ref.WeakReference;

public class RatioDrawable
extends BitmapDrawable {
    private float ratio;
    private WeakReference<ImageView> ref;
    private boolean adjusted;
    private Matrix m;
    private int w;
    private float anchor;

    public RatioDrawable(Resources res, Bitmap bm, ImageView iv, float ratio, float anchor) {
        super(res, bm);
        this.ref = new WeakReference<ImageView>(iv);
        this.ratio = ratio;
        this.anchor = anchor;
        iv.setScaleType(ImageView.ScaleType.MATRIX);
        Matrix m = new Matrix();
        iv.setImageMatrix(m);
        this.adjust(iv, bm, false);
    }

    private int getWidth(ImageView iv) {
        int width = 0;
        ViewGroup.LayoutParams lp = iv.getLayoutParams();
        if (lp != null) {
            width = lp.width;
        }
        if (width <= 0) {
            width = iv.getWidth();
        }
        if (width > 0) {
            width = width - iv.getPaddingLeft() - iv.getPaddingRight();
        }
        return width;
    }

    public void draw(Canvas canvas) {
        ImageView iv = null;
        if (this.ref != null) {
            iv = (ImageView)this.ref.get();
        }
        if (this.ratio == 0.0f || iv == null) {
            super.draw(canvas);
        } else {
            Bitmap bm = this.getBitmap();
            this.draw(canvas, iv, bm);
        }
    }

    private void draw(Canvas canvas, ImageView iv, Bitmap bm) {
        Matrix m = this.getMatrix(iv, bm);
        if (m != null) {
            int vpad = iv.getPaddingTop() + iv.getPaddingBottom();
            int hpad = iv.getPaddingLeft() + iv.getPaddingRight();
            if (vpad > 0 || hpad > 0) {
                canvas.clipRect(0, 0, iv.getWidth() - hpad, iv.getHeight() - vpad);
            }
            canvas.drawBitmap(bm, m, this.getPaint());
        }
        if (!this.adjusted) {
            this.adjust(iv, bm, true);
        }
    }

    private void adjust(ImageView iv, Bitmap bm, boolean done) {
        int vw = this.getWidth(iv);
        if (vw <= 0) {
            return;
        }
        int dw = bm.getWidth();
        int dh = bm.getHeight();
        int th = this.targetHeight(dw, dh, vw) + iv.getPaddingTop() + iv.getPaddingBottom();
        ViewGroup.LayoutParams lp = iv.getLayoutParams();
        if (lp == null) {
            return;
        }
        int vh = lp.height;
        if (th != vh) {
            lp.height = th;
            iv.setLayoutParams(lp);
        }
        if (done) {
            this.adjusted = true;
        }
    }

    private int targetHeight(int dw, int dh, int vw) {
        float r = this.ratio;
        if (this.ratio == Float.MAX_VALUE) {
            r = (float)dh / (float)dw;
        }
        return (int)((float)vw * r);
    }

    private Matrix getMatrix(ImageView iv, Bitmap bm) {
        int dw = bm.getWidth();
        if (this.m != null && dw == this.w) {
            return this.m;
        }
        int dh = bm.getHeight();
        int vw = this.getWidth(iv);
        int vh = this.targetHeight(dw, dh, vw);
        if (dw <= 0 || dh <= 0 || vw <= 0 || vh <= 0) {
            return null;
        }
        if (this.m == null || dw != this.w) {
            float scale;
            float dx = 0.0f;
            float dy = 0.0f;
            this.m = new Matrix();
            if (dw * vh >= vw * dh) {
                scale = (float)vh / (float)dh;
                dx = ((float)vw - (float)dw * scale) * 0.5f;
            } else {
                scale = (float)vw / (float)dw;
                float sy = this.getYOffset(dw, dh);
                dy = ((float)vh - (float)dh * scale) * sy;
            }
            this.m.setScale(scale, scale);
            this.m.postTranslate(dx, dy);
            this.w = dw;
        }
        return this.m;
    }

    private float getYOffset(int vwidth, int vheight) {
        if (this.anchor != Float.MAX_VALUE) {
            return (1.0f - this.anchor) / 2.0f;
        }
        float ratio = (float)vheight / (float)vwidth;
        ratio = Math.min(1.5f, ratio);
        ratio = Math.max(1.0f, ratio);
        return 0.25f + (1.5f - ratio) / 2.0f;
    }
}

