/*
 * Decompiled with CFR 0.152.
 */
package com.tiger.useragent;

import com.google.common.base.Strings;
import com.tiger.useragent.UserAgentInfo;
import com.tiger.useragent.browser.Browser;
import com.tiger.useragent.browser.BrowserParser;
import com.tiger.useragent.device.Device;
import com.tiger.useragent.device.DeviceMap;
import com.tiger.useragent.device.DeviceParser;
import com.tiger.useragent.device.DevicePattern;
import com.tiger.useragent.enums.DeviceType;
import com.tiger.useragent.enums.NetType;
import com.tiger.useragent.enums.OsType;
import com.tiger.useragent.os.Os;
import com.tiger.useragent.os.OsParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class Parser {
    private OsParser osParser;
    private BrowserParser browserParser;
    private DeviceParser deviceParser;
    private DeviceMap deviceMap;
    protected static final Object LOCK = new Object();
    private static final ConcurrentMap<String, DeviceType> dMap = new ConcurrentHashMap<String, DeviceType>();
    private static final ConcurrentMap<String, NetType> netMap = new ConcurrentHashMap<String, NetType>();
    private static final ConcurrentMap<String, OsType> osMap = new ConcurrentHashMap<String, OsType>();
    private static final Pattern pattern = Pattern.compile("\\.net( clr | client )?(?<ver>\\d(\\.\\d)?)(\\.\\d+)*[ce;$) ]", 2);
    private static final Pattern netTypePattern = Pattern.compile("\\W(WIFI|5G|4G|3G|2G)\\W*", 2);
    private static final Pattern deviceIdPattern = Pattern.compile("[\\s&;\"](deviceid|deviceId|sdk_guid|UTDID|GUID|guid|Id|ID|id|udid|UDID|MZ)[\" /:=]+([\\w-]+)", 2);

    public Parser() throws IOException {
        this.readConfigs();
    }

    private void readConfigs() throws IOException {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        try (InputStream stream = Parser.class.getResourceAsStream("/OSConfig.yaml");){
            List osParserConfigs = (List)yaml.load(stream);
            if (osParserConfigs == null) {
                throw new IllegalArgumentException("OSConfig.yaml loading failed.");
            }
            this.osParser = OsParser.fromList(osParserConfigs);
        }
        stream = Parser.class.getResourceAsStream("/BrowserConfig.yaml");
        var3_3 = null;
        try {
            List browserParserConfigs = (List)yaml.load(stream);
            if (browserParserConfigs == null) {
                throw new IllegalArgumentException("BrowserConfig.yaml loading failed.");
            }
            this.browserParser = BrowserParser.fromList(browserParserConfigs);
        }
        catch (Throwable browserParserConfigs) {
            var3_3 = browserParserConfigs;
            throw browserParserConfigs;
        }
        finally {
            if (stream != null) {
                if (var3_3 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable browserParserConfigs) {
                        var3_3.addSuppressed(browserParserConfigs);
                    }
                } else {
                    stream.close();
                }
            }
        }
        var3_3 = null;
        try (InputStream configStream = Parser.class.getResourceAsStream("/DeviceConfig.yaml");){
            List deviceParserConfigs = (List)yaml.load(configStream);
            if (deviceParserConfigs == null) {
                throw new IllegalArgumentException("DeviceConfig.yaml loading failed.");
            }
            List<DevicePattern> patterns = DeviceParser.patternsFromList(deviceParserConfigs);
            this.deviceParser = new DeviceParser(patterns);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        var3_3 = null;
        try (InputStream dictionaryStream = Parser.class.getResourceAsStream("/DeviceDictionary.txt");){
            this.deviceMap = DeviceMap.mapFromFile(dictionaryStream);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    public UserAgentInfo parse(String agentString) {
        if (agentString == null) {
            return null;
        }
        Device device = this.parseDevice(agentString);
        if (device.getDeviceType().equals((Object)DeviceType.Spider)) {
            return this.buildUserAgentInfo(Os.DEFAULT_OS, Browser.DEFAULT_BROWSER, device, (Pair<String, NetType>)Pair.of((Object)"-", (Object)((Object)NetType.Other)), "-");
        }
        Os os = this.parseOS(agentString);
        Browser browser = this.parseBrowser(agentString);
        Pair<String, NetType> pair = this.parseNetType(agentString);
        if (os == null) {
            os = Os.DEFAULT_OS;
        } else if (os.isTv()) {
            device = Device.DEFAULT_TV;
        } else if (os.isMobile() && !device.isMobile() && device.getDeviceType() != DeviceType.TV) {
            device = Device.DEFAULT_PHONE_SCREEN;
        }
        return this.buildUserAgentInfo(os, browser, device, pair, "-");
    }

    public Pair<String, NetType> parseNetType(String agentString) {
        Matcher matcher = netTypePattern.matcher(agentString.toUpperCase());
        String result = "";
        if (matcher.find()) {
            result = matcher.group(1);
        }
        String key = Strings.isNullOrEmpty((String)result) ? "-" : result;
        NetType value = this.getNetType(key);
        return Pair.of((Object)key, (Object)((Object)value));
    }

    public String parseDeviceId(String agentString) {
        Matcher matcher = deviceIdPattern.matcher(agentString.toLowerCase());
        String result = "";
        if (matcher.find()) {
            result = matcher.group(2);
        }
        return Strings.isNullOrEmpty((String)result) || result.length() < 8 ? "-" : result;
    }

    public Device parseDevice(String agentString) {
        Device device = this.deviceParser.parse(agentString);
        return this.deviceMap.parseDevice(device);
    }

    public Browser parseBrowser(String agentString) {
        return this.browserParser.parse(agentString);
    }

    public Os parseOS(String agentString) {
        return this.osParser.parse(agentString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceType getDeviceType(String deviceType) {
        if (Strings.isNullOrEmpty((String)deviceType)) {
            return DeviceType.Other;
        }
        String key = deviceType.trim();
        if (!dMap.containsKey(key)) {
            Object object = LOCK;
            synchronized (object) {
                if (!dMap.containsKey(key)) {
                    DeviceType item = DeviceType.parseOf(key);
                    dMap.put(key, item);
                }
            }
        }
        return (DeviceType)((Object)dMap.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetType getNetType(String netType) {
        if (Strings.isNullOrEmpty((String)netType)) {
            return NetType.Other;
        }
        String key = netType.trim();
        if (!netMap.containsKey(key)) {
            Object object = LOCK;
            synchronized (object) {
                if (!netMap.containsKey(key)) {
                    NetType item = NetType.parseOf(key);
                    netMap.put(key, item);
                }
            }
        }
        return (NetType)((Object)netMap.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OsType getOsType(String os) {
        if (Strings.isNullOrEmpty((String)os)) {
            return OsType.Other;
        }
        String key = os.trim();
        if (!osMap.containsKey(key)) {
            Object object = LOCK;
            synchronized (object) {
                if (!osMap.containsKey(key)) {
                    OsType item = OsType.parseOf(key);
                    osMap.put(key, item);
                }
            }
        }
        return (OsType)((Object)osMap.get(key));
    }

    private UserAgentInfo buildUserAgentInfo(Os os, Browser browser, Device device, Pair<String, NetType> netTypePair, String deviceId) {
        UserAgentInfo userAgentInfo = new UserAgentInfo();
        String detail = "-".equalsIgnoreCase(os.getFamily()) || StringUtils.isEmpty((CharSequence)os.getMajor()) ? os.getFamily() : (StringUtils.isEmpty((CharSequence)os.getMinor()) ? os.getFamily() + " " + os.getMajor() : os.getFamily() + " " + os.getMajor() + "." + os.getMinor());
        String osVersion = StringUtils.replace((String)os.getFamily(), (String)os.getBrand(), (String)"").trim();
        userAgentInfo.setOsName(os.getBrand());
        userAgentInfo.setOsDetail(detail);
        userAgentInfo.setOsType(this.getOsType(os.getBrand()).getValue());
        userAgentInfo.setOsVersion(osVersion);
        detail = StringUtils.isEmpty((CharSequence)browser.getMajor()) ? browser.getFamily() : (StringUtils.isEmpty((CharSequence)browser.getMinor()) ? browser.getFamily() + " " + browser.getMajor() : browser.getFamily() + " " + browser.getMajor() + "." + browser.getMinor());
        String browserVersion = StringUtils.replace((String)detail, (String)browser.getBrand(), (String)"").trim();
        userAgentInfo.setBrowserName(browser.getBrand());
        userAgentInfo.setBrowserDetail(detail);
        userAgentInfo.setBrowserVersion(browserVersion);
        String deviceType = device.getDeviceType().toString();
        userAgentInfo.setDeviceBrand(device.getBrand());
        userAgentInfo.setDeviceName(device.getFamily());
        userAgentInfo.setDeviceType(deviceType);
        userAgentInfo.setIsMobile(device.isMobile());
        userAgentInfo.setIntDeviceType(this.getDeviceType(deviceType).getValue());
        userAgentInfo.setNetType((CharSequence)netTypePair.getKey());
        userAgentInfo.setIntNetType(((NetType)((Object)netTypePair.getValue())).getValue());
        return userAgentInfo;
    }
}

