/*
 * Decompiled with CFR 0.152.
 */
package com.tiger.useragent;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.tiger.useragent.Parser;
import com.tiger.useragent.UserAgentInfo;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentParser
extends Parser {
    private static final Logger logger = LoggerFactory.getLogger(UserAgentParser.class);
    private static final String CACHE_FILE = "./UserAgentCache.dat";
    private static final String CACHE_VERSION_KEY = "cache.version";
    private static final long CACHE_VERSION_VALUE = 1L;
    private static final Schema CACHE_SCHEMA = Schema.createMap((Schema)UserAgentInfo.getClassSchema());
    private static UserAgentParser instance;
    private final LoadingCache<String, UserAgentInfo> cache;

    public UserAgentParser(LoadingCache<String, UserAgentInfo> cache) throws IOException {
        this.cache = cache;
        this.loadCache();
    }

    public UserAgentParser() throws IOException {
        CacheLoader<String, UserAgentInfo> loader = new CacheLoader<String, UserAgentInfo>(){

            public UserAgentInfo load(String key) {
                return UserAgentParser.this.parse(key);
            }
        };
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)loader);
        this.loadCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserAgentParser getInstance() throws IOException {
        if (instance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (instance == null) {
                    instance = new UserAgentParser();
                }
            }
        }
        return instance;
    }

    public static UserAgentParser newInstance() throws IOException {
        return new UserAgentParser();
    }

    public UserAgentInfo getUserAgentInfo(String agentString) {
        return (UserAgentInfo)((Object)this.cache.getUnchecked((Object)agentString));
    }

    public UserAgentInfo parseUserAgent(String agentString) {
        return this.parse(agentString);
    }

    public void loadCache() {
        this.loadCache(CACHE_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCache(String filePath) {
        SpecificDatumReader datumReader = new SpecificDatumReader(CACHE_SCHEMA);
        DataFileReader reader = null;
        try {
            reader = new DataFileReader(new File(filePath), (DatumReader)datumReader);
            if (reader.getMetaLong(CACHE_VERSION_KEY) != 1L) {
                logger.warn("UserAgentCache version NOT matched, Expected {}, Actual {}.", (Object)1L, (Object)reader.getMetaLong(CACHE_VERSION_KEY));
                return;
            }
            while (reader.hasNext()) {
                this.cache.putAll((Map)reader.next());
            }
        }
        catch (IOException ignore) {
            logger.warn("Deserialize UserAgentInfo FAILED when opening: {}", (Object)filePath);
        }
        catch (Exception e) {
            logger.warn("Deserialize UserAgentInfo FAILED: ", (Throwable)e);
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
            }
            catch (IOException e) {
                logger.warn("close DataFileReader FAILED: ", (Throwable)e);
            }
        }
    }

    public void saveCache() {
        this.saveCache(CACHE_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCache(String filePath) {
        SpecificDatumWriter datumWriter = new SpecificDatumWriter(CACHE_SCHEMA);
        DataFileWriter writer = null;
        try {
            writer = new DataFileWriter((DatumWriter)datumWriter);
            writer.setMeta(CACHE_VERSION_KEY, 1L);
            writer.create(CACHE_SCHEMA, new File(filePath));
            writer.append((Object)this.cache.asMap());
        }
        catch (IOException e) {
            logger.warn("Serialize UserAgentInfo FAILED: ", (Throwable)e);
        }
        finally {
            try {
                if (null != writer) {
                    writer.close();
                }
            }
            catch (IOException e) {
                logger.warn("close DataFileWriter FAILED: ", (Throwable)e);
            }
        }
    }

    static {
        GenericData.setStringType((Schema)CACHE_SCHEMA, (GenericData.StringType)GenericData.StringType.String);
    }
}

