/*
 * Decompiled with CFR 0.152.
 */
package com.tiger.useragent.browser;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.tiger.useragent.browser.Browser;
import com.tiger.useragent.browser.BrowserPattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BrowserParser {
    private final List<BrowserPattern> patterns;

    public BrowserParser(List<BrowserPattern> patterns) {
        this.patterns = patterns;
    }

    public static BrowserParser fromList(List<Map<String, String>> configList) {
        ArrayList configPatterns = Lists.newArrayList();
        for (Map<String, String> configMap : configList) {
            configPatterns.add(BrowserPattern.patternFromMap(configMap));
        }
        return new BrowserParser(configPatterns);
    }

    public Browser parse(String uaString) {
        if (Strings.isNullOrEmpty((String)uaString)) {
            return Browser.DEFAULT_BROWSER;
        }
        for (BrowserPattern p : this.patterns) {
            Browser browser = p.match(uaString);
            if (browser == null) continue;
            return browser;
        }
        return Browser.DEFAULT_BROWSER;
    }
}

