/*
 * Decompiled with CFR 0.152.
 */
package com.tiger.useragent.device;

import com.google.common.base.Strings;
import com.tiger.useragent.Parser;
import com.tiger.useragent.device.Device;
import com.tiger.useragent.enums.DeviceType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DeviceMap {
    private Map<String, Device> map;
    public static final int DEVICE_TYPE_LENGTH = 5;
    public static final int DEVICE_FAMILY = 0;
    public static final int DEVICE_BRAND = 1;
    public static final int RE_DEVICE_FAMILY = 2;
    public static final int DEVICE_TYPE = 3;
    public static final int DEVICE_SCREEN_SIZE = 4;

    DeviceMap(Map<String, Device> map) {
        this.map = map;
    }

    public static DeviceMap mapFromFile(InputStream stream) throws IOException {
        HashMap<String, Device> map = new HashMap<String, Device>();
        try (InputStream inputStream = Parser.class.getResourceAsStream("/DeviceDictionary_Auto.txt");){
            DeviceMap.fillMap(inputStream, map);
        }
        DeviceMap.fillMap(stream, map);
        return new DeviceMap(map);
    }

    private static void fillMap(InputStream stream, Map<String, Device> map) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "utf-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] items;
                if (DeviceMap.isCommentOrBlank(line) || (items = line.split(",,")).length != 5) continue;
                String key = items[0];
                DeviceType deviceType = DeviceType.parseOf(items[3]);
                map.put(key, new Device(items[1], items[2], deviceType, true, items[4]));
            }
        }
    }

    private static boolean isCommentOrBlank(String line) {
        return line.startsWith("#") || StringUtils.isBlank((CharSequence)line) || Strings.isNullOrEmpty((String)line);
    }

    public Device parseDevice(Device device) {
        if (device.deviceType.equals((Object)DeviceType.PC) || device.deviceType.equals((Object)DeviceType.Spider) || device.family == null || "-".equals(device.family)) {
            return device;
        }
        String replaceFamily = StringUtils.trimToEmpty((String)StringUtils.replaceEach((String)device.family, (String[])new String[]{"\u3000"}, (String[])new String[]{""}));
        if ("".equals(replaceFamily)) {
            return new Device(device.brand, "-", device.deviceType, device.isMobile, "-");
        }
        if ("".equals(replaceFamily.replaceAll("/", ""))) {
            return device;
        }
        String family = device.family.split("/")[0].replace('_', ' ').toUpperCase();
        if (this.map.containsKey(family)) {
            return this.map.get(family);
        }
        return device;
    }
}

