/*
 * Decompiled with CFR 0.152.
 */
package com.tiger.useragent.device;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.tiger.useragent.device.Device;
import com.tiger.useragent.device.DevicePattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DeviceParser {
    private List<DevicePattern> patterns;

    public DeviceParser(List<DevicePattern> patterns) {
        this.patterns = patterns;
    }

    public static List<DevicePattern> patternsFromList(List<Map<String, String>> configList) {
        ArrayList configPatterns = Lists.newArrayList();
        for (Map<String, String> configMap : configList) {
            configPatterns.add(DevicePattern.patternFromMap(configMap));
        }
        return configPatterns;
    }

    public Device parse(String agentString) {
        if (Strings.isNullOrEmpty((String)agentString)) {
            return Device.DEFAULT_PC_SCREEN;
        }
        for (DevicePattern p : this.patterns) {
            Device device = p.match(agentString);
            if (device == null) continue;
            return device;
        }
        String lower = agentString.toLowerCase();
        if (lower.contains("ottsdk")) {
            return Device.DEFAULT_TV;
        }
        if (lower.contains("android") || lower.contains("phone") || lower.contains("mobile")) {
            return Device.DEFAULT_PHONE_SCREEN;
        }
        return Device.DEFAULT_PC_SCREEN;
    }
}

